/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.sensitivity;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleUnaryOperator;

public final class MutablePointSensitivities
implements PointSensitivityBuilder {
    private final List<PointSensitivity> sensitivities = new ArrayList<PointSensitivity>();

    public MutablePointSensitivities() {
    }

    public MutablePointSensitivities(PointSensitivity sensitivity) {
        ArgChecker.notNull((Object)sensitivity, (String)"sensitivity");
        this.sensitivities.add(sensitivity);
    }

    public MutablePointSensitivities(List<? extends PointSensitivity> sensitivities) {
        ArgChecker.notNull(sensitivities, (String)"sensitivities");
        this.sensitivities.addAll(sensitivities);
    }

    public int size() {
        return this.sensitivities.size();
    }

    public ImmutableList<PointSensitivity> getSensitivities() {
        return ImmutableList.copyOf(this.sensitivities);
    }

    public MutablePointSensitivities add(PointSensitivity sensitivity) {
        ArgChecker.notNull((Object)sensitivity, (String)"sensitivity");
        this.sensitivities.add(sensitivity);
        return this;
    }

    public MutablePointSensitivities addAll(List<PointSensitivity> sensitivities) {
        ArgChecker.notNull(sensitivities, (String)"sensitivities");
        this.sensitivities.addAll(sensitivities);
        return this;
    }

    public MutablePointSensitivities addAll(MutablePointSensitivities other) {
        this.sensitivities.addAll(other.sensitivities);
        return this;
    }

    @Override
    public MutablePointSensitivities withCurrency(Currency currency) {
        this.sensitivities.replaceAll(ps -> ps.withCurrency(currency));
        return this;
    }

    @Override
    public MutablePointSensitivities multipliedBy(double factor) {
        return this.mapSensitivity(s -> s * factor);
    }

    @Override
    public MutablePointSensitivities mapSensitivity(DoubleUnaryOperator operator) {
        this.sensitivities.replaceAll(cs -> cs.withSensitivity(operator.applyAsDouble(cs.getSensitivity())));
        return this;
    }

    @Override
    public MutablePointSensitivities combinedWith(PointSensitivityBuilder other) {
        return other.buildInto(this);
    }

    @Override
    public MutablePointSensitivities buildInto(MutablePointSensitivities combination) {
        return combination == this ? combination : combination.addAll(this);
    }

    @Override
    public PointSensitivities build() {
        return this.toImmutable();
    }

    @Override
    public MutablePointSensitivities cloned() {
        return new MutablePointSensitivities(new ArrayList<PointSensitivity>(this.sensitivities));
    }

    public MutablePointSensitivities sort() {
        this.sensitivities.sort(PointSensitivity::compareKey);
        return this;
    }

    @Override
    public MutablePointSensitivities normalize() {
        this.sensitivities.sort(PointSensitivity::compareKey);
        PointSensitivity previous = this.sensitivities.get(0);
        for (int i = 1; i < this.sensitivities.size(); ++i) {
            PointSensitivity current = this.sensitivities.get(i);
            if (current.compareKey(previous) == 0) {
                current = previous.withSensitivity(previous.getSensitivity() + current.getSensitivity());
                this.sensitivities.set(i - 1, current);
                this.sensitivities.remove(i);
                --i;
            }
            previous = current;
        }
        return this;
    }

    public PointSensitivities toImmutable() {
        return PointSensitivities.of(this.sensitivities);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MutablePointSensitivities) {
            MutablePointSensitivities other = (MutablePointSensitivities)obj;
            return this.sensitivities.equals(other.sensitivities);
        }
        return false;
    }

    public int hashCode() {
        return this.sensitivities.hashCode();
    }

    public String toString() {
        return new StringBuilder(64).append("MutablePointSensitivities{sensitivities=").append(this.sensitivities).append('}').toString();
    }
}

