/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.sensitivity;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.market.sensitivity.MutablePointSensitivities;
import com.opengamma.strata.market.sensitivity.NoPointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import java.util.Arrays;
import java.util.List;
import java.util.function.DoubleUnaryOperator;

public interface PointSensitivityBuilder {
    public static PointSensitivityBuilder none() {
        return NoPointSensitivity.INSTANCE;
    }

    public static PointSensitivityBuilder of(PointSensitivity ... sensitivities) {
        switch (sensitivities.length) {
            case 0: {
                return PointSensitivityBuilder.none();
            }
            case 1: {
                PointSensitivity sens = sensitivities[0];
                if (sens instanceof PointSensitivityBuilder) {
                    return (PointSensitivityBuilder)((Object)sens);
                }
                return new MutablePointSensitivities(sens);
            }
        }
        return new MutablePointSensitivities(Arrays.asList(sensitivities));
    }

    public static PointSensitivityBuilder of(List<? extends PointSensitivity> sensitivities) {
        switch (sensitivities.size()) {
            case 0: {
                return PointSensitivityBuilder.none();
            }
            case 1: {
                PointSensitivity sens = sensitivities.get(0);
                if (sens instanceof PointSensitivityBuilder) {
                    return (PointSensitivityBuilder)((Object)sens);
                }
                return new MutablePointSensitivities(sens);
            }
        }
        return new MutablePointSensitivities(sensitivities);
    }

    public PointSensitivityBuilder withCurrency(Currency var1);

    default public PointSensitivityBuilder multipliedBy(double factor) {
        return this.mapSensitivity(s -> s * factor);
    }

    public PointSensitivityBuilder mapSensitivity(DoubleUnaryOperator var1);

    public PointSensitivityBuilder normalize();

    default public PointSensitivityBuilder combinedWith(PointSensitivityBuilder other) {
        if (other instanceof MutablePointSensitivities) {
            MutablePointSensitivities otherCombination = (MutablePointSensitivities)other;
            return this.buildInto(otherCombination);
        }
        MutablePointSensitivities combination = new MutablePointSensitivities();
        return other.buildInto(this.buildInto(combination));
    }

    public MutablePointSensitivities buildInto(MutablePointSensitivities var1);

    default public PointSensitivities build() {
        return this.buildInto(new MutablePointSensitivities()).toImmutable();
    }

    public PointSensitivityBuilder cloned();
}

