/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.surface;

import com.google.common.base.Preconditions;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import com.opengamma.strata.market.surface.DefaultSurfaceMetadata;
import com.opengamma.strata.market.surface.Surface;
import com.opengamma.strata.market.surface.SurfaceMetadata;
import com.opengamma.strata.market.surface.SurfaceName;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ConstantSurface
implements Surface,
ImmutableBean,
Serializable {
    private static final DoubleArray SENSITIVITY = DoubleArray.of((double)1.0);
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SurfaceMetadata metadata;
    @PropertyDefinition
    private final double zValue;
    private static final long serialVersionUID = 1L;

    public static ConstantSurface of(String name, double zValue) {
        return ConstantSurface.of(SurfaceName.of(name), zValue);
    }

    public static ConstantSurface of(SurfaceName name, double zValue) {
        return new ConstantSurface(DefaultSurfaceMetadata.of(name), zValue);
    }

    public static ConstantSurface of(SurfaceMetadata metadata, double zValue) {
        return new ConstantSurface(metadata, zValue);
    }

    private Object readResolve() {
        return new ConstantSurface(this.metadata, this.zValue);
    }

    @Override
    public int getParameterCount() {
        return 1;
    }

    @Override
    public double getParameter(int parameterIndex) {
        Preconditions.checkElementIndex((int)parameterIndex, (int)1);
        return this.zValue;
    }

    @Override
    public ConstantSurface withParameter(int parameterIndex, double newValue) {
        Preconditions.checkElementIndex((int)parameterIndex, (int)1);
        return new ConstantSurface(this.metadata, newValue);
    }

    @Override
    public ConstantSurface withPerturbation(ParameterPerturbation perturbation) {
        return new ConstantSurface(this.metadata, perturbation.perturbParameter(0, this.zValue, this.getParameterMetadata(0)));
    }

    @Override
    public double zValue(double x, double y) {
        return this.zValue;
    }

    @Override
    public UnitParameterSensitivity zValueParameterSensitivity(double x, double y) {
        return this.createParameterSensitivity(SENSITIVITY);
    }

    @Override
    public ValueDerivatives firstPartialDerivatives(double x, double y) {
        return ValueDerivatives.of((double)this.zValue, (DoubleArray)DoubleArray.of((double)0.0, (double)0.0));
    }

    @Override
    public ConstantSurface withMetadata(SurfaceMetadata metadata) {
        return new ConstantSurface(metadata.withParameterMetadata(null), this.zValue);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ConstantSurface(SurfaceMetadata metadata, double zValue) {
        JodaBeanUtils.notNull((Object)metadata, (String)"metadata");
        this.metadata = metadata;
        this.zValue = zValue;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SurfaceMetadata getMetadata() {
        return this.metadata;
    }

    public double getZValue() {
        return this.zValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ConstantSurface other = (ConstantSurface)obj;
            return JodaBeanUtils.equal((Object)this.metadata, (Object)other.metadata) && JodaBeanUtils.equal((double)this.zValue, (double)other.zValue);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.metadata);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.zValue);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("ConstantSurface{");
        buf.append("metadata").append('=').append(JodaBeanUtils.toString((Object)this.metadata)).append(',').append(' ');
        buf.append("zValue").append('=').append(JodaBeanUtils.toString((Object)this.zValue));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ConstantSurface> {
        private SurfaceMetadata metadata;
        private double zValue;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return this.metadata;
                }
                case -719790825: {
                    return this.zValue;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    this.metadata = (SurfaceMetadata)newValue;
                    break;
                }
                case -719790825: {
                    this.zValue = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ConstantSurface build() {
            return new ConstantSurface(this.metadata, this.zValue);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("ConstantSurface.Builder{");
            buf.append("metadata").append('=').append(JodaBeanUtils.toString((Object)this.metadata)).append(',').append(' ');
            buf.append("zValue").append('=').append(JodaBeanUtils.toString((Object)this.zValue));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SurfaceMetadata> metadata = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"metadata", ConstantSurface.class, SurfaceMetadata.class);
        private final MetaProperty<Double> zValue = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"zValue", ConstantSurface.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"metadata", "zValue"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return this.metadata;
                }
                case -719790825: {
                    return this.zValue;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ConstantSurface> builder() {
            return new Builder();
        }

        public Class<? extends ConstantSurface> beanType() {
            return ConstantSurface.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SurfaceMetadata> metadata() {
            return this.metadata;
        }

        public MetaProperty<Double> zValue() {
            return this.zValue;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return ((ConstantSurface)bean).getMetadata();
                }
                case -719790825: {
                    return ((ConstantSurface)bean).getZValue();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

