/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.surface;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.tuple.DoublesPair;
import com.opengamma.strata.collect.tuple.ObjDoublePair;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import com.opengamma.strata.market.surface.NodalSurface;
import com.opengamma.strata.market.surface.SurfaceMetadata;
import com.opengamma.strata.market.surface.interpolator.BoundSurfaceInterpolator;
import com.opengamma.strata.market.surface.interpolator.SurfaceInterpolator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.stream.IntStream;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class InterpolatedNodalSurface
implements NodalSurface,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SurfaceMetadata metadata;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DoubleArray xValues;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DoubleArray yValues;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DoubleArray zValues;
    @PropertyDefinition(validate="notNull")
    private final SurfaceInterpolator interpolator;
    private final transient BoundSurfaceInterpolator boundInterpolator;
    private final transient List<ParameterMetadata> parameterMetadata;
    private static final long serialVersionUID = 1L;

    public static InterpolatedNodalSurface of(SurfaceMetadata metadata, DoubleArray xValues, DoubleArray yValues, DoubleArray zValues, SurfaceInterpolator interpolator) {
        return new InterpolatedNodalSurface(metadata, xValues, yValues, zValues, interpolator);
    }

    public static InterpolatedNodalSurface ofUnsorted(SurfaceMetadata metadata, DoubleArray xValues, DoubleArray yValues, DoubleArray zValues, SurfaceInterpolator interpolator) {
        return new InterpolatedNodalSurface(metadata, xValues, yValues, zValues, interpolator, true);
    }

    @ImmutableConstructor
    private InterpolatedNodalSurface(SurfaceMetadata metadata, DoubleArray xValues, DoubleArray yValues, DoubleArray zValues, SurfaceInterpolator interpolator) {
        this.validateInputs(metadata, xValues, yValues, zValues, interpolator);
        for (int i2 = 1; i2 < xValues.size(); ++i2) {
            if (xValues.get(i2) < xValues.get(i2 - 1)) {
                throw new IllegalArgumentException("Array of x-values must be sorted");
            }
            if (xValues.get(i2) != xValues.get(i2 - 1) || !(yValues.get(i2) <= yValues.get(i2 - 1))) continue;
            throw new IllegalArgumentException("Array of y-values must be sorted and unique within x-values");
        }
        this.metadata = metadata;
        this.xValues = xValues;
        this.yValues = yValues;
        this.zValues = zValues;
        this.interpolator = interpolator;
        this.boundInterpolator = interpolator.bind(xValues, yValues, zValues);
        this.parameterMetadata = (List)IntStream.range(0, this.getParameterCount()).mapToObj(i -> metadata.getParameterMetadata(i)).collect(Guavate.toImmutableList());
    }

    private InterpolatedNodalSurface(SurfaceMetadata metadata, DoubleArray xValues, DoubleArray yValues, DoubleArray zValues, SurfaceInterpolator interpolator, boolean sort) {
        SurfaceMetadata sortedMetadata;
        this.validateInputs(metadata, xValues, yValues, zValues, interpolator);
        TreeMap<DoublesPair, ObjDoublePair> sorted = new TreeMap<DoublesPair, ObjDoublePair>();
        for (int i2 = 0; i2 < xValues.size(); ++i2) {
            ParameterMetadata pm = metadata.getParameterMetadata(i2);
            sorted.put(DoublesPair.of((double)xValues.get(i2), (double)yValues.get(i2)), ObjDoublePair.of((Object)pm, (double)zValues.get(i2)));
        }
        double[] sortedX = new double[sorted.size()];
        double[] sortedY = new double[sorted.size()];
        double[] sortedZ = new double[sorted.size()];
        ParameterMetadata[] sortedPm = new ParameterMetadata[sorted.size()];
        int pos = 0;
        for (Map.Entry entry : sorted.entrySet()) {
            sortedX[pos] = ((DoublesPair)entry.getKey()).getFirst();
            sortedY[pos] = ((DoublesPair)entry.getKey()).getSecond();
            sortedZ[pos] = ((ObjDoublePair)entry.getValue()).getSecond();
            sortedPm[pos] = (ParameterMetadata)((ObjDoublePair)entry.getValue()).getFirst();
            ++pos;
        }
        this.metadata = sortedMetadata = metadata.withParameterMetadata(Arrays.asList(sortedPm));
        this.xValues = DoubleArray.ofUnsafe((double[])sortedX);
        this.yValues = DoubleArray.ofUnsafe((double[])sortedY);
        this.zValues = DoubleArray.ofUnsafe((double[])sortedZ);
        HashMap<DoublesPair, Double> pairs = new HashMap<DoublesPair, Double>();
        for (int i3 = 0; i3 < xValues.size(); ++i3) {
            pairs.put(DoublesPair.of((double)xValues.get(i3), (double)yValues.get(i3)), zValues.get(i3));
        }
        this.interpolator = interpolator;
        this.boundInterpolator = interpolator.bind(this.xValues, this.yValues, this.zValues);
        this.parameterMetadata = (List)IntStream.range(0, this.getParameterCount()).mapToObj(i -> sortedMetadata.getParameterMetadata(i)).collect(Guavate.toImmutableList());
    }

    private void validateInputs(SurfaceMetadata metadata, DoubleArray xValues, DoubleArray yValues, DoubleArray zValues, SurfaceInterpolator interpolator) {
        ArgChecker.notNull((Object)metadata, (String)"metadata");
        ArgChecker.notNull((Object)xValues, (String)"times");
        ArgChecker.notNull((Object)yValues, (String)"values");
        ArgChecker.notNull((Object)interpolator, (String)"interpolator");
        if (xValues.size() < 2) {
            throw new IllegalArgumentException("Length of x-values must be at least 2");
        }
        if (xValues.size() != yValues.size()) {
            throw new IllegalArgumentException("Length of x-values and y-values must match");
        }
        if (xValues.size() != zValues.size()) {
            throw new IllegalArgumentException("Length of x-values and z-values must match");
        }
        metadata.getParameterMetadata().ifPresent(params -> {
            if (xValues.size() != params.size()) {
                throw new IllegalArgumentException("Length of x-values and parameter metadata must match when metadata present");
            }
        });
    }

    private Object readResolve() {
        return new InterpolatedNodalSurface(this.metadata, this.xValues, this.yValues, this.zValues, this.interpolator);
    }

    @Override
    public int getParameterCount() {
        return this.zValues.size();
    }

    @Override
    public double getParameter(int parameterIndex) {
        return this.zValues.get(parameterIndex);
    }

    @Override
    public InterpolatedNodalSurface withParameter(int parameterIndex, double newValue) {
        return this.withZValues(this.zValues.with(parameterIndex, newValue));
    }

    @Override
    public InterpolatedNodalSurface withPerturbation(ParameterPerturbation perturbation) {
        int size = this.zValues.size();
        DoubleArray perturbedValues = DoubleArray.of((int)size, i -> perturbation.perturbParameter(i, this.zValues.get(i), this.getParameterMetadata(i)));
        return this.withZValues(perturbedValues);
    }

    @Override
    public double zValue(double x, double y) {
        return this.boundInterpolator.interpolate(x, y);
    }

    @Override
    public UnitParameterSensitivity zValueParameterSensitivity(double x, double y) {
        DoubleArray sensitivityValues = this.boundInterpolator.parameterSensitivity(x, y);
        return this.createParameterSensitivity(sensitivityValues);
    }

    @Override
    public ValueDerivatives firstPartialDerivatives(double x, double y) {
        return this.boundInterpolator.firstPartialDerivatives(x, y);
    }

    @Override
    public InterpolatedNodalSurface withMetadata(SurfaceMetadata metadata) {
        return new InterpolatedNodalSurface(metadata, this.xValues, this.yValues, this.zValues, this.interpolator);
    }

    @Override
    public InterpolatedNodalSurface withZValues(DoubleArray zValues) {
        return new InterpolatedNodalSurface(this.metadata, this.xValues, this.yValues, zValues, this.interpolator);
    }

    @Override
    public UnitParameterSensitivity createParameterSensitivity(DoubleArray sensitivities) {
        return UnitParameterSensitivity.of(this.getName(), this.parameterMetadata, sensitivities);
    }

    @Override
    public CurrencyParameterSensitivity createParameterSensitivity(Currency currency, DoubleArray sensitivities) {
        return CurrencyParameterSensitivity.of(this.getName(), this.parameterMetadata, currency, sensitivities);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SurfaceMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public DoubleArray getXValues() {
        return this.xValues;
    }

    @Override
    public DoubleArray getYValues() {
        return this.yValues;
    }

    @Override
    public DoubleArray getZValues() {
        return this.zValues;
    }

    public SurfaceInterpolator getInterpolator() {
        return this.interpolator;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            InterpolatedNodalSurface other = (InterpolatedNodalSurface)obj;
            return JodaBeanUtils.equal((Object)this.metadata, (Object)other.metadata) && JodaBeanUtils.equal((Object)this.xValues, (Object)other.xValues) && JodaBeanUtils.equal((Object)this.yValues, (Object)other.yValues) && JodaBeanUtils.equal((Object)this.zValues, (Object)other.zValues) && JodaBeanUtils.equal((Object)this.interpolator, (Object)other.interpolator);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.metadata);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.xValues);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.yValues);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.zValues);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.interpolator);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("InterpolatedNodalSurface{");
        buf.append("metadata").append('=').append(JodaBeanUtils.toString((Object)this.metadata)).append(',').append(' ');
        buf.append("xValues").append('=').append(JodaBeanUtils.toString((Object)this.xValues)).append(',').append(' ');
        buf.append("yValues").append('=').append(JodaBeanUtils.toString((Object)this.yValues)).append(',').append(' ');
        buf.append("zValues").append('=').append(JodaBeanUtils.toString((Object)this.zValues)).append(',').append(' ');
        buf.append("interpolator").append('=').append(JodaBeanUtils.toString((Object)this.interpolator));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<InterpolatedNodalSurface> {
        private SurfaceMetadata metadata;
        private DoubleArray xValues;
        private DoubleArray yValues;
        private DoubleArray zValues;
        private SurfaceInterpolator interpolator;

        private Builder() {
        }

        private Builder(InterpolatedNodalSurface beanToCopy) {
            this.metadata = beanToCopy.getMetadata();
            this.xValues = beanToCopy.getXValues();
            this.yValues = beanToCopy.getYValues();
            this.zValues = beanToCopy.getZValues();
            this.interpolator = beanToCopy.getInterpolator();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return this.metadata;
                }
                case 1681280954: {
                    return this.xValues;
                }
                case -1726182661: {
                    return this.yValues;
                }
                case -838678980: {
                    return this.zValues;
                }
                case 2096253127: {
                    return this.interpolator;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    this.metadata = (SurfaceMetadata)newValue;
                    break;
                }
                case 1681280954: {
                    this.xValues = (DoubleArray)newValue;
                    break;
                }
                case -1726182661: {
                    this.yValues = (DoubleArray)newValue;
                    break;
                }
                case -838678980: {
                    this.zValues = (DoubleArray)newValue;
                    break;
                }
                case 2096253127: {
                    this.interpolator = (SurfaceInterpolator)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public InterpolatedNodalSurface build() {
            return new InterpolatedNodalSurface(this.metadata, this.xValues, this.yValues, this.zValues, this.interpolator);
        }

        public Builder metadata(SurfaceMetadata metadata) {
            JodaBeanUtils.notNull((Object)metadata, (String)"metadata");
            this.metadata = metadata;
            return this;
        }

        public Builder xValues(DoubleArray xValues) {
            JodaBeanUtils.notNull((Object)xValues, (String)"xValues");
            this.xValues = xValues;
            return this;
        }

        public Builder yValues(DoubleArray yValues) {
            JodaBeanUtils.notNull((Object)yValues, (String)"yValues");
            this.yValues = yValues;
            return this;
        }

        public Builder zValues(DoubleArray zValues) {
            JodaBeanUtils.notNull((Object)zValues, (String)"zValues");
            this.zValues = zValues;
            return this;
        }

        public Builder interpolator(SurfaceInterpolator interpolator) {
            JodaBeanUtils.notNull((Object)interpolator, (String)"interpolator");
            this.interpolator = interpolator;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("InterpolatedNodalSurface.Builder{");
            buf.append("metadata").append('=').append(JodaBeanUtils.toString((Object)this.metadata)).append(',').append(' ');
            buf.append("xValues").append('=').append(JodaBeanUtils.toString((Object)this.xValues)).append(',').append(' ');
            buf.append("yValues").append('=').append(JodaBeanUtils.toString((Object)this.yValues)).append(',').append(' ');
            buf.append("zValues").append('=').append(JodaBeanUtils.toString((Object)this.zValues)).append(',').append(' ');
            buf.append("interpolator").append('=').append(JodaBeanUtils.toString((Object)this.interpolator));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SurfaceMetadata> metadata = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"metadata", InterpolatedNodalSurface.class, SurfaceMetadata.class);
        private final MetaProperty<DoubleArray> xValues = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"xValues", InterpolatedNodalSurface.class, DoubleArray.class);
        private final MetaProperty<DoubleArray> yValues = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yValues", InterpolatedNodalSurface.class, DoubleArray.class);
        private final MetaProperty<DoubleArray> zValues = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"zValues", InterpolatedNodalSurface.class, DoubleArray.class);
        private final MetaProperty<SurfaceInterpolator> interpolator = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"interpolator", InterpolatedNodalSurface.class, SurfaceInterpolator.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"metadata", "xValues", "yValues", "zValues", "interpolator"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return this.metadata;
                }
                case 1681280954: {
                    return this.xValues;
                }
                case -1726182661: {
                    return this.yValues;
                }
                case -838678980: {
                    return this.zValues;
                }
                case 2096253127: {
                    return this.interpolator;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends InterpolatedNodalSurface> beanType() {
            return InterpolatedNodalSurface.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SurfaceMetadata> metadata() {
            return this.metadata;
        }

        public MetaProperty<DoubleArray> xValues() {
            return this.xValues;
        }

        public MetaProperty<DoubleArray> yValues() {
            return this.yValues;
        }

        public MetaProperty<DoubleArray> zValues() {
            return this.zValues;
        }

        public MetaProperty<SurfaceInterpolator> interpolator() {
            return this.interpolator;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return ((InterpolatedNodalSurface)bean).getMetadata();
                }
                case 1681280954: {
                    return ((InterpolatedNodalSurface)bean).getXValues();
                }
                case -1726182661: {
                    return ((InterpolatedNodalSurface)bean).getYValues();
                }
                case -838678980: {
                    return ((InterpolatedNodalSurface)bean).getZValues();
                }
                case 2096253127: {
                    return ((InterpolatedNodalSurface)bean).getInterpolator();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

