/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.cern;

import com.opengamma.strata.math.impl.cern.PersistentObject;
import com.opengamma.strata.math.impl.cern.RandomEngine;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntUnaryOperator;

abstract class AbstractDistribution
extends PersistentObject
implements DoubleUnaryOperator,
IntUnaryOperator {
    private static final long serialVersionUID = 1L;
    protected RandomEngine randomGenerator;

    protected AbstractDistribution() {
    }

    @Override
    public double applyAsDouble(double dummy) {
        return this.nextDouble();
    }

    @Override
    public int applyAsInt(int dummy) {
        return this.nextInt();
    }

    @Override
    public Object clone() {
        AbstractDistribution copy = (AbstractDistribution)super.clone();
        if (this.randomGenerator != null) {
            copy.randomGenerator = (RandomEngine)this.randomGenerator.clone();
        }
        return copy;
    }

    protected RandomEngine getRandomGenerator() {
        return this.randomGenerator;
    }

    public static RandomEngine makeDefaultGenerator() {
        return RandomEngine.makeDefault();
    }

    public abstract double nextDouble();

    public int nextInt() {
        return (int)Math.round(this.nextDouble());
    }

    protected void setRandomGenerator(RandomEngine randomGenerator) {
        this.randomGenerator = randomGenerator;
    }
}

