/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.cern;

import com.opengamma.strata.math.impl.cern.Constants;
import com.opengamma.strata.math.impl.cern.GammaFunctions;
import com.opengamma.strata.math.impl.cern.Polynomial;

public class Probability
extends Constants {
    protected static final double[] P0 = new double[]{-59.96335010141079, 98.00107541859997, -56.67628574690703, 13.931260938727968, -1.2391658386738125};
    protected static final double[] Q0 = new double[]{1.9544885833814176, 4.676279128988815, 86.36024213908905, -225.46268785411937, 200.26021238006066, -82.03722561683334, 15.90562251262117, -1.1833162112133};
    protected static final double[] P1 = new double[]{4.0554489230596245, 31.525109459989388, 57.16281922464213, 44.08050738932008, 14.684956192885803, 2.1866330685079025, -0.1402560791713545, -0.03504246268278482, -8.574567851546854E-4};
    protected static final double[] Q1 = new double[]{15.779988325646675, 45.39076351288792, 41.3172038254672, 15.04253856929075, 2.504649462083094, -0.14218292285478779, -0.03808064076915783, -9.332594808954574E-4};
    protected static final double[] P2 = new double[]{3.2377489177694603, 6.915228890689842, 3.9388102529247444, 1.3330346081580755, 0.20148538954917908, 0.012371663481782003, 3.0158155350823543E-4, 2.6580697468673755E-6, 6.239745391849833E-9};
    protected static final double[] Q2 = new double[]{6.02427039364742, 3.6798356385616087, 1.3770209948908132, 0.21623699359449663, 0.013420400608854318, 3.2801446468212774E-4, 2.8924786474538068E-6, 6.790194080099813E-9};

    protected Probability() {
    }

    public static double beta(double a, double b, double x) {
        return GammaFunctions.incompleteBeta(a, b, x);
    }

    public static double betaComplemented(double a, double b, double x) {
        return GammaFunctions.incompleteBeta(b, a, x);
    }

    public static double binomial(int k, int n, double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException();
        }
        if (k < 0 || n < k) {
            throw new IllegalArgumentException();
        }
        if (k == n) {
            return 1.0;
        }
        if (k == 0) {
            return Math.pow(1.0 - p, n - k);
        }
        return GammaFunctions.incompleteBeta(n - k, k + 1, 1.0 - p);
    }

    public static double binomialComplemented(int k, int n, double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException();
        }
        if (k < 0 || n < k) {
            throw new IllegalArgumentException();
        }
        if (k == n) {
            return 0.0;
        }
        if (k == 0) {
            return 1.0 - Math.pow(1.0 - p, n - k);
        }
        return GammaFunctions.incompleteBeta(k + 1, n - k, p);
    }

    public static double chiSquare(double v, double x) throws ArithmeticException {
        if (x < 0.0 || v < 1.0) {
            return 0.0;
        }
        return GammaFunctions.incompleteGamma(v / 2.0, x / 2.0);
    }

    public static double chiSquareComplemented(double v, double x) throws ArithmeticException {
        if (x < 0.0 || v < 1.0) {
            return 0.0;
        }
        return GammaFunctions.incompleteGammaComplement(v / 2.0, x / 2.0);
    }

    public static double errorFunction(double x) throws ArithmeticException {
        double[] T = new double[]{9.604973739870516, 90.02601972038427, 2232.005345946843, 7003.325141128051, 55592.30130103949};
        double[] U = new double[]{33.56171416475031, 521.3579497801527, 4594.323829709801, 22629.000061389095, 49267.39426086359};
        if (Math.abs(x) > 1.0) {
            return 1.0 - Probability.errorFunctionComplemented(x);
        }
        double z = x * x;
        double y = x * Polynomial.polevl(z, T, 4) / Polynomial.p1evl(z, U, 5);
        return y;
    }

    public static double errorFunctionComplemented(double a) throws ArithmeticException {
        double q;
        double p;
        double[] P = new double[]{2.461969814735305E-10, 0.5641895648310689, 7.463210564422699, 48.63719709856814, 196.5208329560771, 526.4451949954773, 934.5285271719576, 1027.5518868951572, 557.5353353693994};
        double[] Q = new double[]{13.228195115474499, 86.70721408859897, 354.9377788878199, 975.7085017432055, 1823.9091668790973, 2246.3376081871097, 1656.6630919416134, 557.5353408177277};
        double[] R = new double[]{0.5641895835477551, 1.275366707599781, 5.019050422511805, 6.160210979930536, 7.4097426995044895, 2.9788666537210022};
        double[] S = new double[]{2.2605286322011726, 9.396035249380015, 12.048953980809666, 17.08144507475659, 9.608968090632859, 3.369076451000815};
        double x = a < 0.0 ? -a : a;
        if (x < 1.0) {
            return 1.0 - Probability.errorFunction(a);
        }
        double z = -a * a;
        if (z < -709.782712893384) {
            if (a < 0.0) {
                return 2.0;
            }
            return 0.0;
        }
        z = Math.exp(z);
        if (x < 8.0) {
            p = Polynomial.polevl(x, P, 8);
            q = Polynomial.p1evl(x, Q, 8);
        } else {
            p = Polynomial.polevl(x, R, 5);
            q = Polynomial.p1evl(x, S, 6);
        }
        double y = z * p / q;
        if (a < 0.0) {
            y = 2.0 - y;
        }
        if (y == 0.0) {
            if (a < 0.0) {
                return 2.0;
            }
            return 0.0;
        }
        return y;
    }

    public static double gamma(double a, double b, double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return GammaFunctions.incompleteGamma(b, a * x);
    }

    public static double gammaComplemented(double a, double b, double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return GammaFunctions.incompleteGammaComplement(b, a * x);
    }

    public static double negativeBinomial(int k, int n, double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException();
        }
        if (k < 0) {
            return 0.0;
        }
        return GammaFunctions.incompleteBeta(n, k + 1, p);
    }

    public static double negativeBinomialComplemented(int k, int n, double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException();
        }
        if (k < 0) {
            return 0.0;
        }
        return GammaFunctions.incompleteBeta(k + 1, n, 1.0 - p);
    }

    public static double normal(double a) throws ArithmeticException {
        double y;
        double x = a * 0.7071067811865476;
        double z = Math.abs(x);
        if (z < 0.7071067811865476) {
            y = 0.5 + 0.5 * Probability.errorFunction(x);
        } else {
            y = 0.5 * Probability.errorFunctionComplemented(z);
            if (x > 0.0) {
                y = 1.0 - y;
            }
        }
        return y;
    }

    public static double normal(double mean, double variance, double x) throws ArithmeticException {
        if (x > 0.0) {
            return 0.5 + 0.5 * Probability.errorFunction((x - mean) / Math.sqrt(2.0 * variance));
        }
        return 0.5 - 0.5 * Probability.errorFunction(-(x - mean) / Math.sqrt(2.0 * variance));
    }

    public static double normalInverse(double y0) throws ArithmeticException {
        double s2pi = Math.sqrt(Math.PI * 2);
        if (y0 <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (y0 >= 1.0) {
            throw new IllegalArgumentException();
        }
        boolean code = true;
        double y = y0;
        if (y > 0.8646647167633873) {
            y = 1.0 - y;
            code = false;
        }
        if (y > 0.1353352832366127) {
            double y2 = (y -= 0.5) * y;
            double x = y + y * (y2 * Polynomial.polevl(y2, P0, 4) / Polynomial.p1evl(y2, Q0, 8));
            return x *= s2pi;
        }
        double x = Math.sqrt(-2.0 * Math.log(y));
        double x0 = x - Math.log(x) / x;
        double z = 1.0 / x;
        double x1 = x < 8.0 ? z * Polynomial.polevl(z, P1, 8) / Polynomial.p1evl(z, Q1, 8) : z * Polynomial.polevl(z, P2, 8) / Polynomial.p1evl(z, Q2, 8);
        x = x0 - x1;
        if (code) {
            x = -x;
        }
        return x;
    }

    public static double poisson(int k, double mean) throws ArithmeticException {
        if (mean < 0.0) {
            throw new IllegalArgumentException();
        }
        if (k < 0) {
            return 0.0;
        }
        return GammaFunctions.incompleteGammaComplement(k + 1, mean);
    }

    public static double poissonComplemented(int k, double mean) throws ArithmeticException {
        if (mean < 0.0) {
            throw new IllegalArgumentException();
        }
        if (k < -1) {
            return 0.0;
        }
        return GammaFunctions.incompleteGamma(k + 1, mean);
    }

    public static double studentT(double k, double t) throws ArithmeticException {
        if (k <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (t == 0.0) {
            return 0.5;
        }
        double cdf = 0.5 * GammaFunctions.incompleteBeta(0.5 * k, 0.5, k / (k + t * t));
        if (t >= 0.0) {
            cdf = 1.0 - cdf;
        }
        return cdf;
    }

    public static double studentTInverse(double alpha, int size) {
        double cumProb = 1.0 - alpha / 2.0;
        cumProb = 1.0 - alpha / 2.0;
        double x1 = Probability.normalInverse(cumProb);
        if (size > 200) {
            return x1;
        }
        double f1 = Probability.studentT(size, x1) - cumProb;
        double x2 = x1;
        double f2 = f1;
        do {
            if (f1 > 0.0) {
                x2 /= 2.0;
                continue;
            }
            x2 += x1;
        } while (f1 * (f2 = Probability.studentT(size, x2) - cumProb) > 0.0);
        do {
            double s12;
            double x3;
            double f3;
            if (Math.abs(f3 = Probability.studentT(size, x3 = x2 - f2 / (s12 = (f2 - f1) / (x2 - x1))) - cumProb) < 1.0E-8) {
                return x3;
            }
            if (f3 * f2 < 0.0) {
                x1 = x2;
                f1 = f2;
                x2 = x3;
                f2 = f3;
                continue;
            }
            double g = f2 / (f2 + f3);
            f1 = g * f1;
            x2 = x3;
            f2 = f3;
        } while (Math.abs(x2 - x1) > 0.001);
        if (Math.abs(f2) <= Math.abs(f1)) {
            return x2;
        }
        return x1;
    }
}

