/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.differentiation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.differentiation.Differentiator;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebra;
import com.opengamma.strata.math.impl.matrix.OGMatrixAlgebra;
import java.util.function.Function;

public class MatrixFieldFirstOrderDifferentiator
implements Differentiator<DoubleArray, DoubleMatrix, DoubleMatrix[]> {
    private static final MatrixAlgebra MA = new OGMatrixAlgebra();
    private static final double DEFAULT_EPS = 1.0E-5;
    private final double eps;
    private final double twoEps;
    private final double oneOverTwpEps;

    public MatrixFieldFirstOrderDifferentiator() {
        this.eps = 1.0E-5;
        this.twoEps = 2.0E-5;
        this.oneOverTwpEps = 1.0 / this.twoEps;
    }

    public MatrixFieldFirstOrderDifferentiator(double eps) {
        ArgChecker.isTrue((eps > 1.0E-15 ? 1 : 0) != 0, (String)"eps of {} is below machine tolerance of 1e-15. Please choose a higher value", (double)eps);
        this.eps = eps;
        this.twoEps = 2.0 * eps;
        this.oneOverTwpEps = 1.0 / this.twoEps;
    }

    @Override
    public Function<DoubleArray, DoubleMatrix[]> differentiate(final Function<DoubleArray, DoubleMatrix> function) {
        ArgChecker.notNull(function, (String)"function");
        return new Function<DoubleArray, DoubleMatrix[]>(){

            @Override
            public DoubleMatrix[] apply(DoubleArray x) {
                ArgChecker.notNull((Object)x, (String)"x");
                int n = x.size();
                DoubleMatrix[] res = new DoubleMatrix[n];
                for (int i = 0; i < n; ++i) {
                    double xi = x.get(i);
                    DoubleMatrix up = (DoubleMatrix)function.apply(x.with(i, xi + MatrixFieldFirstOrderDifferentiator.this.eps));
                    DoubleMatrix down = (DoubleMatrix)function.apply(x.with(i, xi - MatrixFieldFirstOrderDifferentiator.this.eps));
                    res[i] = (DoubleMatrix)MA.scale(MA.subtract((Matrix)up, (Matrix)down), MatrixFieldFirstOrderDifferentiator.this.oneOverTwpEps);
                }
                return res;
            }
        };
    }

    @Override
    public Function<DoubleArray, DoubleMatrix[]> differentiate(final Function<DoubleArray, DoubleMatrix> function, final Function<DoubleArray, Boolean> domain) {
        ArgChecker.notNull(function, (String)"function");
        ArgChecker.notNull(domain, (String)"domain");
        final double[] wFwd = new double[]{-3.0 / this.twoEps, 4.0 / this.twoEps, -1.0 / this.twoEps};
        final double[] wCent = new double[]{-1.0 / this.twoEps, 0.0, 1.0 / this.twoEps};
        final double[] wBack = new double[]{1.0 / this.twoEps, -4.0 / this.twoEps, 3.0 / this.twoEps};
        return new Function<DoubleArray, DoubleMatrix[]>(){

            @Override
            public DoubleMatrix[] apply(DoubleArray x) {
                ArgChecker.notNull((Object)x, (String)"x");
                ArgChecker.isTrue((boolean)((Boolean)domain.apply(x)), (String)"point {} is not in the function domain", (Object[])new Object[]{x.toString()});
                int n = x.size();
                DoubleMatrix[] y = new DoubleMatrix[3];
                DoubleMatrix[] res = new DoubleMatrix[n];
                for (int i = 0; i < n; ++i) {
                    double[] w;
                    double xi = x.get(i);
                    DoubleArray xPlusOneEps = x.with(i, xi + MatrixFieldFirstOrderDifferentiator.this.eps);
                    DoubleArray xMinusOneEps = x.with(i, xi - MatrixFieldFirstOrderDifferentiator.this.eps);
                    if (!((Boolean)domain.apply(xPlusOneEps)).booleanValue()) {
                        DoubleArray xMinusTwoEps = x.with(i, xi - MatrixFieldFirstOrderDifferentiator.this.twoEps);
                        if (!((Boolean)domain.apply(xMinusTwoEps)).booleanValue()) {
                            throw new MathException("cannot get derivative at point " + x.toString() + " in direction " + i);
                        }
                        y[0] = (DoubleMatrix)function.apply(xMinusTwoEps);
                        y[2] = (DoubleMatrix)function.apply(x);
                        y[1] = (DoubleMatrix)function.apply(xMinusOneEps);
                        w = wBack;
                    } else if (!((Boolean)domain.apply(xMinusOneEps)).booleanValue()) {
                        y[1] = (DoubleMatrix)function.apply(xPlusOneEps);
                        y[0] = (DoubleMatrix)function.apply(x);
                        y[2] = (DoubleMatrix)function.apply(x.with(i, xi + MatrixFieldFirstOrderDifferentiator.this.twoEps));
                        w = wFwd;
                    } else {
                        y[2] = (DoubleMatrix)function.apply(xPlusOneEps);
                        y[0] = (DoubleMatrix)function.apply(xMinusOneEps);
                        w = wCent;
                    }
                    res[i] = (DoubleMatrix)MA.add(MA.scale((Matrix)y[0], w[0]), MA.scale((Matrix)y[2], w[2]));
                    if (w[1] == 0.0) continue;
                    res[i] = (DoubleMatrix)MA.add((Matrix)res[i], MA.scale((Matrix)y[1], w[1]));
                }
                return res;
            }
        };
    }
}

