/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.differentiation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.differentiation.Differentiator;
import com.opengamma.strata.math.impl.differentiation.FiniteDifferenceType;
import java.util.function.Function;

public class ScalarFirstOrderDifferentiator
implements Differentiator<Double, Double, Double> {
    private static final double DEFAULT_EPS = 1.0E-5;
    private static final double MIN_EPS = Math.sqrt(Double.MIN_NORMAL);
    private final double eps;
    private final double twoEps;
    private final FiniteDifferenceType differenceType;

    public ScalarFirstOrderDifferentiator() {
        this(FiniteDifferenceType.CENTRAL, 1.0E-5);
    }

    public ScalarFirstOrderDifferentiator(FiniteDifferenceType differenceType) {
        this(differenceType, 1.0E-5);
    }

    public ScalarFirstOrderDifferentiator(FiniteDifferenceType differenceType, double eps) {
        ArgChecker.notNull((Object)((Object)differenceType), (String)"differenceType");
        ArgChecker.isTrue((eps >= MIN_EPS ? 1 : 0) != 0, (String)"eps of {} is too small. Please choose a value > {}, such as 1e-5*size of domain", (Object[])new Object[]{eps, MIN_EPS});
        this.differenceType = differenceType;
        this.eps = eps;
        this.twoEps = 2.0 * eps;
    }

    @Override
    public Function<Double, Double> differentiate(final Function<Double, Double> function) {
        ArgChecker.notNull(function, (String)"function");
        switch (this.differenceType) {
            case FORWARD: {
                return new Function<Double, Double>(){

                    @Override
                    public Double apply(Double x) {
                        ArgChecker.notNull((Object)x, (String)"x");
                        return ((Double)function.apply(x + ScalarFirstOrderDifferentiator.this.eps) - (Double)function.apply(x)) / ScalarFirstOrderDifferentiator.this.eps;
                    }
                };
            }
            case CENTRAL: {
                return new Function<Double, Double>(){

                    @Override
                    public Double apply(Double x) {
                        ArgChecker.notNull((Object)x, (String)"x");
                        return ((Double)function.apply(x + ScalarFirstOrderDifferentiator.this.eps) - (Double)function.apply(x - ScalarFirstOrderDifferentiator.this.eps)) / ScalarFirstOrderDifferentiator.this.twoEps;
                    }
                };
            }
            case BACKWARD: {
                return new Function<Double, Double>(){

                    @Override
                    public Double apply(Double x) {
                        ArgChecker.notNull((Object)x, (String)"x");
                        return ((Double)function.apply(x) - (Double)function.apply(x - ScalarFirstOrderDifferentiator.this.eps)) / ScalarFirstOrderDifferentiator.this.eps;
                    }
                };
            }
        }
        throw new IllegalArgumentException("Can only handle forward, backward and central differencing");
    }

    @Override
    public Function<Double, Double> differentiate(final Function<Double, Double> function, final Function<Double, Boolean> domain) {
        ArgChecker.notNull(function, (String)"function");
        ArgChecker.notNull(domain, (String)"domain");
        final double[] wFwd = new double[]{-3.0 / this.twoEps, 4.0 / this.twoEps, -1.0 / this.twoEps};
        final double[] wCent = new double[]{-1.0 / this.twoEps, 0.0, 1.0 / this.twoEps};
        final double[] wBack = new double[]{1.0 / this.twoEps, -4.0 / this.twoEps, 3.0 / this.twoEps};
        return new Function<Double, Double>(){

            @Override
            public Double apply(Double x) {
                double[] w;
                ArgChecker.notNull((Object)x, (String)"x");
                ArgChecker.isTrue((boolean)((Boolean)domain.apply(x)), (String)"point {} is not in the function domain", (Object[])new Object[]{x.toString()});
                double[] y = new double[3];
                if (!((Boolean)domain.apply(x + ScalarFirstOrderDifferentiator.this.eps)).booleanValue()) {
                    if (!((Boolean)domain.apply(x - ScalarFirstOrderDifferentiator.this.eps)).booleanValue()) {
                        throw new MathException("cannot get derivative at point " + x.toString());
                    }
                    y[0] = (Double)function.apply(x - ScalarFirstOrderDifferentiator.this.twoEps);
                    y[1] = (Double)function.apply(x - ScalarFirstOrderDifferentiator.this.eps);
                    y[2] = (Double)function.apply(x);
                    w = wBack;
                } else if (!((Boolean)domain.apply(x - ScalarFirstOrderDifferentiator.this.eps)).booleanValue()) {
                    y[0] = (Double)function.apply(x);
                    y[1] = (Double)function.apply(x + ScalarFirstOrderDifferentiator.this.eps);
                    y[2] = (Double)function.apply(x + ScalarFirstOrderDifferentiator.this.twoEps);
                    w = wFwd;
                } else {
                    y[0] = (Double)function.apply(x - ScalarFirstOrderDifferentiator.this.eps);
                    y[2] = (Double)function.apply(x + ScalarFirstOrderDifferentiator.this.eps);
                    w = wCent;
                }
                double res = y[0] * w[0] + y[2] * w[2];
                if (w[1] != 0.0) {
                    res += y[1] * w[1];
                }
                return res;
            }
        };
    }
}

