/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.differentiation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.differentiation.Differentiator;
import java.util.function.Function;

public class ScalarSecondOrderDifferentiator
implements Differentiator<Double, Double, Double> {
    private static final double DEFAULT_EPS = 1.0E-4;
    private final double eps;
    private final double epsSqr;
    private final double twoEps;
    private final double threeEps;

    public ScalarSecondOrderDifferentiator() {
        this(1.0E-4);
    }

    public ScalarSecondOrderDifferentiator(double eps) {
        this.eps = eps;
        this.epsSqr = eps * eps;
        this.twoEps = 2.0 * eps;
        this.threeEps = 3.0 * eps;
    }

    @Override
    public Function<Double, Double> differentiate(final Function<Double, Double> function) {
        ArgChecker.notNull(function, (String)"function");
        return new Function<Double, Double>(){

            @Override
            public Double apply(Double x) {
                ArgChecker.notNull((Object)x, (String)"x");
                return ((Double)function.apply(x + ScalarSecondOrderDifferentiator.this.eps) + (Double)function.apply(x - ScalarSecondOrderDifferentiator.this.eps) - 2.0 * (Double)function.apply(x)) / ScalarSecondOrderDifferentiator.this.epsSqr;
            }
        };
    }

    @Override
    public Function<Double, Double> differentiate(final Function<Double, Double> function, final Function<Double, Boolean> domain) {
        ArgChecker.notNull(function, (String)"function");
        ArgChecker.notNull(domain, (String)"domain");
        return new Function<Double, Double>(){

            @Override
            public Double apply(Double x) {
                ArgChecker.notNull((Object)x, (String)"x");
                ArgChecker.isTrue((boolean)((Boolean)domain.apply(x)), (String)"point {} is not in the function domain", (Object[])new Object[]{x.toString()});
                if (!((Boolean)domain.apply(x + ScalarSecondOrderDifferentiator.this.threeEps)).booleanValue()) {
                    if (!((Boolean)domain.apply(x - ScalarSecondOrderDifferentiator.this.threeEps)).booleanValue()) {
                        throw new IllegalArgumentException("cannot get derivative at point " + x.toString());
                    }
                    return (-((Double)function.apply(x - ScalarSecondOrderDifferentiator.this.threeEps)).doubleValue() + 4.0 * (Double)function.apply(x - ScalarSecondOrderDifferentiator.this.twoEps) - 5.0 * (Double)function.apply(x - ScalarSecondOrderDifferentiator.this.eps) + 2.0 * (Double)function.apply(x)) / ScalarSecondOrderDifferentiator.this.epsSqr;
                }
                if (!((Boolean)domain.apply(x - ScalarSecondOrderDifferentiator.this.eps)).booleanValue()) {
                    return (-((Double)function.apply(x + ScalarSecondOrderDifferentiator.this.threeEps)).doubleValue() + 4.0 * (Double)function.apply(x + ScalarSecondOrderDifferentiator.this.twoEps) - 5.0 * (Double)function.apply(x + ScalarSecondOrderDifferentiator.this.eps) + 2.0 * (Double)function.apply(x)) / ScalarSecondOrderDifferentiator.this.epsSqr;
                }
                return ((Double)function.apply(x + ScalarSecondOrderDifferentiator.this.eps) + (Double)function.apply(x - ScalarSecondOrderDifferentiator.this.eps) - 2.0 * (Double)function.apply(x)) / ScalarSecondOrderDifferentiator.this.epsSqr;
            }
        };
    }
}

