/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.differentiation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.differentiation.Differentiator;
import com.opengamma.strata.math.impl.differentiation.FiniteDifferenceType;
import java.util.function.Function;

public class VectorFieldFirstOrderDifferentiator
implements Differentiator<DoubleArray, DoubleArray, DoubleMatrix> {
    private static final double DEFAULT_EPS = 1.0E-5;
    private final double eps;
    private final double twoEps;
    private final FiniteDifferenceType differenceType;

    public VectorFieldFirstOrderDifferentiator() {
        this(FiniteDifferenceType.CENTRAL, 1.0E-5);
    }

    public VectorFieldFirstOrderDifferentiator(FiniteDifferenceType differenceType) {
        this(differenceType, 1.0E-5);
    }

    public VectorFieldFirstOrderDifferentiator(double eps) {
        this(FiniteDifferenceType.CENTRAL, eps);
    }

    public VectorFieldFirstOrderDifferentiator(FiniteDifferenceType differenceType, double eps) {
        ArgChecker.notNull((Object)((Object)differenceType), (String)"differenceType");
        this.differenceType = differenceType;
        this.eps = eps;
        this.twoEps = 2.0 * eps;
    }

    @Override
    public Function<DoubleArray, DoubleMatrix> differentiate(final Function<DoubleArray, DoubleArray> function) {
        ArgChecker.notNull(function, (String)"function");
        switch (this.differenceType) {
            case FORWARD: {
                return new Function<DoubleArray, DoubleMatrix>(){

                    @Override
                    public DoubleMatrix apply(DoubleArray x) {
                        ArgChecker.notNull((Object)x, (String)"x");
                        DoubleArray y = (DoubleArray)function.apply(x);
                        int n = x.size();
                        int m = y.size();
                        double[][] res = new double[m][n];
                        for (int j = 0; j < n; ++j) {
                            double xj = x.get(j);
                            DoubleArray up = (DoubleArray)function.apply(x.with(j, xj + VectorFieldFirstOrderDifferentiator.this.eps));
                            for (int i = 0; i < m; ++i) {
                                res[i][j] = (up.get(i) - y.get(i)) / VectorFieldFirstOrderDifferentiator.this.eps;
                            }
                        }
                        return DoubleMatrix.copyOf((double[][])res);
                    }
                };
            }
            case CENTRAL: {
                return new Function<DoubleArray, DoubleMatrix>(){

                    @Override
                    public DoubleMatrix apply(DoubleArray x) {
                        ArgChecker.notNull((Object)x, (String)"x");
                        DoubleArray y = (DoubleArray)function.apply(x);
                        int n = x.size();
                        int m = y.size();
                        double[][] res = new double[m][n];
                        for (int j = 0; j < n; ++j) {
                            double xj = x.get(j);
                            DoubleArray up = (DoubleArray)function.apply(x.with(j, xj + VectorFieldFirstOrderDifferentiator.this.eps));
                            DoubleArray down = (DoubleArray)function.apply(x.with(j, xj - VectorFieldFirstOrderDifferentiator.this.eps));
                            for (int i = 0; i < m; ++i) {
                                res[i][j] = (up.get(i) - down.get(i)) / VectorFieldFirstOrderDifferentiator.this.twoEps;
                            }
                        }
                        return DoubleMatrix.copyOf((double[][])res);
                    }
                };
            }
            case BACKWARD: {
                return new Function<DoubleArray, DoubleMatrix>(){

                    @Override
                    public DoubleMatrix apply(DoubleArray x) {
                        ArgChecker.notNull((Object)x, (String)"x");
                        DoubleArray y = (DoubleArray)function.apply(x);
                        int n = x.size();
                        int m = y.size();
                        double[][] res = new double[m][n];
                        for (int j = 0; j < n; ++j) {
                            double xj = x.get(j);
                            DoubleArray down = (DoubleArray)function.apply(x.with(j, xj - VectorFieldFirstOrderDifferentiator.this.eps));
                            for (int i = 0; i < m; ++i) {
                                res[i][j] = (y.get(i) - down.get(i)) / VectorFieldFirstOrderDifferentiator.this.eps;
                            }
                        }
                        return DoubleMatrix.copyOf((double[][])res);
                    }
                };
            }
        }
        throw new IllegalArgumentException("Can only handle forward, backward and central differencing");
    }

    @Override
    public Function<DoubleArray, DoubleMatrix> differentiate(final Function<DoubleArray, DoubleArray> function, final Function<DoubleArray, Boolean> domain) {
        ArgChecker.notNull(function, (String)"function");
        ArgChecker.notNull(domain, (String)"domain");
        final double[] wFwd = new double[]{-3.0, 4.0, -1.0};
        final double[] wCent = new double[]{-1.0, 0.0, 1.0};
        final double[] wBack = new double[]{1.0, -4.0, 3.0};
        return new Function<DoubleArray, DoubleMatrix>(){

            @Override
            public DoubleMatrix apply(DoubleArray x) {
                ArgChecker.notNull((Object)x, (String)"x");
                ArgChecker.isTrue((boolean)((Boolean)domain.apply(x)), (String)"point {} is not in the function domain", (Object[])new Object[]{x.toString()});
                DoubleArray mid = (DoubleArray)function.apply(x);
                int n = x.size();
                int m = mid.size();
                double[][] res = new double[m][n];
                DoubleArray[] y = new DoubleArray[3];
                for (int j = 0; j < n; ++j) {
                    double[] w;
                    double xj = x.get(j);
                    DoubleArray xPlusOneEps = x.with(j, xj + VectorFieldFirstOrderDifferentiator.this.eps);
                    DoubleArray xMinusOneEps = x.with(j, xj - VectorFieldFirstOrderDifferentiator.this.eps);
                    if (!((Boolean)domain.apply(xPlusOneEps)).booleanValue()) {
                        DoubleArray xMinusTwoEps = x.with(j, xj - VectorFieldFirstOrderDifferentiator.this.twoEps);
                        if (!((Boolean)domain.apply(xMinusTwoEps)).booleanValue()) {
                            throw new MathException("cannot get derivative at point " + x.toString() + " in direction " + j);
                        }
                        y[2] = mid;
                        y[0] = (DoubleArray)function.apply(xMinusTwoEps);
                        y[1] = (DoubleArray)function.apply(xMinusOneEps);
                        w = wBack;
                    } else if (!((Boolean)domain.apply(xMinusOneEps)).booleanValue()) {
                        y[0] = mid;
                        y[1] = (DoubleArray)function.apply(xPlusOneEps);
                        y[2] = (DoubleArray)function.apply(x.with(j, xj + VectorFieldFirstOrderDifferentiator.this.twoEps));
                        w = wFwd;
                    } else {
                        y[2] = (DoubleArray)function.apply(xPlusOneEps);
                        y[0] = (DoubleArray)function.apply(xMinusOneEps);
                        y[1] = mid;
                        w = wCent;
                    }
                    for (int i = 0; i < m; ++i) {
                        double sum = 0.0;
                        for (int k = 0; k < 3; ++k) {
                            if (w[k] == 0.0) continue;
                            sum += w[k] * y[k].get(i);
                        }
                        res[i][j] = sum / VectorFieldFirstOrderDifferentiator.this.twoEps;
                    }
                }
                return DoubleMatrix.copyOf((double[][])res);
            }
        };
    }
}

