/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.function;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.function.VectorFunction;

public class ConcatenatedVectorFunction
extends VectorFunction {
    private final int[] xPartition;
    private final int[] yPartition;
    private final int nPartitions;
    private final VectorFunction[] functions;
    private final int sizeDom;
    private final int sizeRange;

    public ConcatenatedVectorFunction(VectorFunction[] functions) {
        ArgChecker.noNulls((Object[])functions, (String)"functions");
        this.functions = functions;
        this.nPartitions = functions.length;
        this.xPartition = new int[this.nPartitions];
        this.yPartition = new int[this.nPartitions];
        int m = 0;
        int n = 0;
        for (int i = 0; i < this.nPartitions; ++i) {
            this.xPartition[i] = functions[i].getLengthOfDomain();
            this.yPartition[i] = functions[i].getLengthOfRange();
            m += this.xPartition[i];
            n += this.yPartition[i];
        }
        this.sizeDom = m;
        this.sizeRange = n;
    }

    @Override
    public DoubleMatrix calculateJacobian(DoubleArray x) {
        ArgChecker.notNull((Object)x, (String)"x");
        ArgChecker.isTrue((x.size() == this.getLengthOfDomain() ? 1 : 0) != 0, (String)"Incorrect length of x. Is {} but should be {}", (Object[])new Object[]{x.size(), this.getLengthOfDomain()});
        double[][] jac = new double[this.getLengthOfRange()][this.getLengthOfDomain()];
        int posInput = 0;
        int pos1 = 0;
        int pos2 = 0;
        for (int i = 0; i < this.nPartitions; ++i) {
            int nRows = this.yPartition[i];
            int nCols = this.xPartition[i];
            DoubleArray sub = x.subArray(posInput, posInput + nCols);
            DoubleMatrix subJac = this.functions[i].calculateJacobian(sub);
            if (nCols > 0) {
                for (int r = 0; r < nRows; ++r) {
                    System.arraycopy(subJac.toArrayUnsafe()[r], 0, jac[pos1++], pos2, nCols);
                }
                pos2 += nCols;
            } else {
                pos1 += nRows;
            }
            posInput += nCols;
        }
        return DoubleMatrix.copyOf((double[][])jac);
    }

    @Override
    public DoubleArray apply(DoubleArray x) {
        ArgChecker.notNull((Object)x, (String)"x");
        ArgChecker.isTrue((x.size() == this.getLengthOfDomain() ? 1 : 0) != 0, (String)"Incorrect length of x. Is {} but should be {}", (Object[])new Object[]{x.size(), this.getLengthOfDomain()});
        double[] y = new double[this.getLengthOfRange()];
        int posInput = 0;
        int posOutput = 0;
        for (int i = 0; i < this.nPartitions; ++i) {
            int length = this.xPartition[i];
            DoubleArray sub = x.subArray(posInput, posInput + length);
            DoubleArray eval = (DoubleArray)this.functions[i].apply(sub);
            eval.copyInto(y, posOutput);
            posInput += length;
            posOutput += eval.size();
        }
        return DoubleArray.copyOf((double[])y);
    }

    @Override
    public int getLengthOfDomain() {
        return this.sizeDom;
    }

    @Override
    public int getLengthOfRange() {
        return this.sizeRange;
    }
}

