/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.function;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.differentiation.FiniteDifferenceType;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;

public interface DoubleFunction1D
extends DoubleUnaryOperator {
    default public DoubleFunction1D derivative() {
        return this.derivative(FiniteDifferenceType.CENTRAL, 1.0E-5);
    }

    default public DoubleFunction1D derivative(FiniteDifferenceType differenceType, final double eps) {
        ArgChecker.notNull((Object)((Object)differenceType), (String)"difference type");
        switch (differenceType) {
            case CENTRAL: {
                return new DoubleFunction1D(){

                    @Override
                    public double applyAsDouble(double x) {
                        return (DoubleFunction1D.this.applyAsDouble(x + eps) - DoubleFunction1D.this.applyAsDouble(x - eps)) / 2.0 / eps;
                    }
                };
            }
            case BACKWARD: {
                return new DoubleFunction1D(){

                    @Override
                    public double applyAsDouble(double x) {
                        return (DoubleFunction1D.this.applyAsDouble(x) - DoubleFunction1D.this.applyAsDouble(x - eps)) / eps;
                    }
                };
            }
            case FORWARD: {
                return new DoubleFunction1D(){

                    @Override
                    public double applyAsDouble(double x) {
                        return (DoubleFunction1D.this.applyAsDouble(x + eps) - DoubleFunction1D.this.applyAsDouble(x)) / eps;
                    }
                };
            }
        }
        throw new IllegalArgumentException("Unhandled FiniteDifferenceType " + (Object)((Object)differenceType));
    }

    default public DoubleFunction1D add(final DoubleFunction1D f) {
        ArgChecker.notNull((Object)f, (String)"f");
        return new DoubleFunction1D(){

            @Override
            public double applyAsDouble(double x) {
                return DoubleFunction1D.this.applyAsDouble(x) + f.applyAsDouble(x);
            }
        };
    }

    default public DoubleFunction1D add(final double a) {
        return new DoubleFunction1D(){

            @Override
            public double applyAsDouble(double x) {
                return DoubleFunction1D.this.applyAsDouble(x) + a;
            }
        };
    }

    default public DoubleFunction1D divide(final DoubleFunction1D f) {
        ArgChecker.notNull((Object)f, (String)"f");
        return new DoubleFunction1D(){

            @Override
            public double applyAsDouble(double x) {
                return DoubleFunction1D.this.applyAsDouble(x) / f.applyAsDouble(x);
            }
        };
    }

    default public DoubleFunction1D divide(final double a) {
        return new DoubleFunction1D(){

            @Override
            public double applyAsDouble(double x) {
                return DoubleFunction1D.this.applyAsDouble(x) / a;
            }
        };
    }

    default public DoubleFunction1D multiply(final DoubleFunction1D f) {
        ArgChecker.notNull((Object)f, (String)"f");
        return new DoubleFunction1D(){

            @Override
            public double applyAsDouble(double x) {
                return DoubleFunction1D.this.applyAsDouble(x) * f.applyAsDouble(x);
            }
        };
    }

    default public DoubleFunction1D multiply(final double a) {
        return new DoubleFunction1D(){

            @Override
            public double applyAsDouble(double x) {
                return DoubleFunction1D.this.applyAsDouble(x) * a;
            }
        };
    }

    default public DoubleFunction1D subtract(final DoubleFunction1D f) {
        ArgChecker.notNull((Object)f, (String)"f");
        return new DoubleFunction1D(){

            @Override
            public double applyAsDouble(double x) {
                return DoubleFunction1D.this.applyAsDouble(x) - f.applyAsDouble(x);
            }
        };
    }

    default public DoubleFunction1D subtract(final double a) {
        return new DoubleFunction1D(){

            @Override
            public double applyAsDouble(double x) {
                return DoubleFunction1D.this.applyAsDouble(x) - a;
            }
        };
    }

    public static DoubleFunction1D from(final Function<Double, Double> f) {
        ArgChecker.notNull(f, (String)"f");
        return new DoubleFunction1D(){

            @Override
            public double applyAsDouble(double x) {
                return (Double)f.apply(x);
            }
        };
    }
}

