/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.function;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.tuple.DoublesPair;
import com.opengamma.strata.math.impl.differentiation.ScalarFieldFirstOrderDifferentiator;
import com.opengamma.strata.math.impl.function.ParameterizedFunction;
import java.util.function.Function;

public abstract class ParameterizedSurface
extends ParameterizedFunction<DoublesPair, DoubleArray, Double> {
    private static final ScalarFieldFirstOrderDifferentiator FIRST_ORDER_DIFF = new ScalarFieldFirstOrderDifferentiator();

    public Function<DoublesPair, DoubleArray> getZParameterSensitivity(final DoubleArray params) {
        return new Function<DoublesPair, DoubleArray>(){

            @Override
            public DoubleArray apply(DoublesPair xy) {
                Function<DoubleArray, Double> f = ParameterizedSurface.this.asFunctionOfParameters(xy);
                Function<DoubleArray, DoubleArray> g = FIRST_ORDER_DIFF.differentiate(f);
                return g.apply(params);
            }
        };
    }
}

