/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.function;

import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.FunctionUtils;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult;

public class PiecewisePolynomialFunction1D {
    public DoubleArray evaluate(PiecewisePolynomialResult pp, double xKey) {
        ArgChecker.notNull((Object)pp, (String)"pp");
        ArgChecker.isFalse((boolean)Double.isNaN(xKey), (String)"xKey containing NaN");
        ArgChecker.isFalse((boolean)Double.isInfinite(xKey), (String)"xKey containing Infinity");
        DoubleArray knots = pp.getKnots();
        int nKnots = knots.size();
        DoubleMatrix coefMatrix = pp.getCoefMatrix();
        int lowerBound = FunctionUtils.getLowerBoundIndex(knots, xKey);
        int indicator = lowerBound == nKnots - 1 ? lowerBound - 1 : lowerBound;
        return DoubleArray.of((int)pp.getDimensions(), i -> {
            DoubleArray coefs = coefMatrix.row(pp.getDimensions() * indicator + i);
            double res = this.getValue(coefs, xKey, knots.get(indicator));
            ArgChecker.isFalse((boolean)Double.isInfinite(res), (String)"Too large input");
            ArgChecker.isFalse((boolean)Double.isNaN(res), (String)"Too large input");
            return res;
        });
    }

    public DoubleMatrix evaluate(PiecewisePolynomialResult pp, double[] xKeys) {
        ArgChecker.notNull((Object)pp, (String)"pp");
        ArgChecker.notNull((Object)xKeys, (String)"xKeys");
        int keyLength = xKeys.length;
        for (int i = 0; i < keyLength; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xKeys[i]), (String)"xKeys containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xKeys[i]), (String)"xKeys containing Infinity");
        }
        DoubleArray knots = pp.getKnots();
        int nKnots = knots.size();
        DoubleMatrix coefMatrix = pp.getCoefMatrix();
        int dim = pp.getDimensions();
        double[][] res = new double[dim][keyLength];
        for (int k = 0; k < dim; ++k) {
            for (int j = 0; j < keyLength; ++j) {
                int indicator = 0;
                if (xKeys[j] < knots.get(1)) {
                    indicator = 0;
                } else {
                    for (int i = 1; i < nKnots - 1; ++i) {
                        if (!(knots.get(i) <= xKeys[j])) continue;
                        indicator = i;
                    }
                }
                DoubleArray coefs = coefMatrix.row(dim * indicator + k);
                res[k][j] = this.getValue(coefs, xKeys[j], knots.get(indicator));
                ArgChecker.isFalse((boolean)Double.isInfinite(res[k][j]), (String)"Too large input");
                ArgChecker.isFalse((boolean)Double.isNaN(res[k][j]), (String)"Too large input");
            }
        }
        return DoubleMatrix.copyOf((double[][])res);
    }

    public DoubleMatrix[] evaluate(PiecewisePolynomialResult pp, double[][] xKeys) {
        ArgChecker.notNull((Object)pp, (String)"pp");
        ArgChecker.notNull((Object)xKeys, (String)"xKeys");
        int keyLength = xKeys[0].length;
        int keyDim = xKeys.length;
        for (int j = 0; j < keyDim; ++j) {
            for (int i = 0; i < keyLength; ++i) {
                ArgChecker.isFalse((boolean)Double.isNaN(xKeys[j][i]), (String)"xKeys containing NaN");
                ArgChecker.isFalse((boolean)Double.isInfinite(xKeys[j][i]), (String)"xKeys containing Infinity");
            }
        }
        DoubleArray knots = pp.getKnots();
        int nKnots = knots.size();
        DoubleMatrix coefMatrix = pp.getCoefMatrix();
        int dim = pp.getDimensions();
        double[][][] res = new double[dim][keyDim][keyLength];
        for (int k = 0; k < dim; ++k) {
            for (int l = 0; l < keyDim; ++l) {
                for (int j = 0; j < keyLength; ++j) {
                    int indicator = 0;
                    if (xKeys[l][j] < knots.get(1)) {
                        indicator = 0;
                    } else {
                        for (int i = 1; i < nKnots - 1; ++i) {
                            if (!(knots.get(i) <= xKeys[l][j])) continue;
                            indicator = i;
                        }
                    }
                    DoubleArray coefs = coefMatrix.row(dim * indicator + k);
                    res[k][l][j] = this.getValue(coefs, xKeys[l][j], knots.get(indicator));
                    ArgChecker.isFalse((boolean)Double.isInfinite(res[k][l][j]), (String)"Too large input");
                    ArgChecker.isFalse((boolean)Double.isNaN(res[k][l][j]), (String)"Too large input");
                }
            }
        }
        DoubleMatrix[] resMat = new DoubleMatrix[dim];
        for (int i = 0; i < dim; ++i) {
            resMat[i] = DoubleMatrix.copyOf((double[][])res[i]);
        }
        return resMat;
    }

    public DoubleArray differentiate(PiecewisePolynomialResult pp, double xKey) {
        ArgChecker.notNull((Object)pp, (String)"pp");
        ArgChecker.isFalse((pp.getOrder() < 2 ? 1 : 0) != 0, (String)"polynomial degree < 1");
        DoubleArray knots = pp.getKnots();
        int nCoefs = pp.getOrder();
        int rowCount = pp.getDimensions() * pp.getNumberOfIntervals();
        int colCount = nCoefs - 1;
        DoubleMatrix coef = DoubleMatrix.of((int)rowCount, (int)colCount, (i, j) -> pp.getCoefMatrix().get(i, j) * (double)(nCoefs - j - 1));
        PiecewisePolynomialResult ppDiff = new PiecewisePolynomialResult(knots, coef, colCount, pp.getDimensions());
        return this.evaluate(ppDiff, xKey);
    }

    public DoubleMatrix differentiate(PiecewisePolynomialResult pp, double[] xKeys) {
        ArgChecker.notNull((Object)pp, (String)"pp");
        ArgChecker.isFalse((pp.getOrder() < 2 ? 1 : 0) != 0, (String)"polynomial degree < 1");
        DoubleArray knots = pp.getKnots();
        int nCoefs = pp.getOrder();
        int rowCount = pp.getDimensions() * pp.getNumberOfIntervals();
        int colCount = nCoefs - 1;
        DoubleMatrix coef = DoubleMatrix.of((int)rowCount, (int)colCount, (i, j) -> pp.getCoefMatrix().get(i, j) * (double)(nCoefs - j - 1));
        PiecewisePolynomialResult ppDiff = new PiecewisePolynomialResult(knots, coef, colCount, pp.getDimensions());
        return this.evaluate(ppDiff, xKeys);
    }

    public DoubleArray differentiateTwice(PiecewisePolynomialResult pp, double xKey) {
        ArgChecker.notNull((Object)pp, (String)"pp");
        ArgChecker.isFalse((pp.getOrder() < 3 ? 1 : 0) != 0, (String)"polynomial degree < 2");
        DoubleArray knots = pp.getKnots();
        int nCoefs = pp.getOrder();
        int rowCount = pp.getDimensions() * pp.getNumberOfIntervals();
        int colCount = nCoefs - 2;
        DoubleMatrix coef = DoubleMatrix.of((int)rowCount, (int)colCount, (i, j) -> pp.getCoefMatrix().get(i, j) * (double)(nCoefs - j - 1) * (double)(nCoefs - j - 2));
        PiecewisePolynomialResult ppDiff = new PiecewisePolynomialResult(knots, coef, nCoefs - 1, pp.getDimensions());
        return this.evaluate(ppDiff, xKey);
    }

    public DoubleMatrix differentiateTwice(PiecewisePolynomialResult pp, double[] xKeys) {
        ArgChecker.notNull((Object)pp, (String)"pp");
        ArgChecker.isFalse((pp.getOrder() < 3 ? 1 : 0) != 0, (String)"polynomial degree < 2");
        DoubleArray knots = pp.getKnots();
        int nCoefs = pp.getOrder();
        int rowCount = pp.getDimensions() * pp.getNumberOfIntervals();
        int colCount = nCoefs - 2;
        DoubleMatrix coef = DoubleMatrix.of((int)rowCount, (int)colCount, (i, j) -> pp.getCoefMatrix().get(i, j) * (double)(nCoefs - j - 1) * (double)(nCoefs - j - 2));
        PiecewisePolynomialResult ppDiff = new PiecewisePolynomialResult(knots, coef, nCoefs - 1, pp.getDimensions());
        return this.evaluate(ppDiff, xKeys);
    }

    public double integrate(PiecewisePolynomialResult pp, double initialKey, double xKey) {
        int i;
        ArgChecker.notNull((Object)pp, (String)"pp");
        ArgChecker.isFalse((boolean)Double.isNaN(initialKey), (String)"initialKey containing NaN");
        ArgChecker.isFalse((boolean)Double.isInfinite(initialKey), (String)"initialKey containing Infinity");
        ArgChecker.isTrue((pp.getDimensions() == 1 ? 1 : 0) != 0, (String)"Dimension should be 1");
        DoubleArray knots = pp.getKnots();
        int nCoefs = pp.getOrder();
        int nKnots = pp.getNumberOfIntervals() + 1;
        int rowCount = nKnots - 1;
        int colCount = nCoefs + 1;
        double[][] res = new double[rowCount][colCount];
        for (int i2 = 0; i2 < rowCount; ++i2) {
            for (int j = 0; j < nCoefs; ++j) {
                res[i2][j] = pp.getCoefMatrix().get(i2, j) / (double)(nCoefs - j);
            }
        }
        double[] constTerms = new double[rowCount];
        int indicator = 0;
        if (initialKey <= knots.get(1)) {
            indicator = 0;
        } else {
            for (int i3 = 1; i3 < rowCount; ++i3) {
                if (!(knots.get(i3) < initialKey)) continue;
                indicator = i3;
            }
        }
        double sum = this.getValue(res[indicator], initialKey, knots.get(indicator));
        for (i = indicator; i < nKnots - 2; ++i) {
            constTerms[i + 1] = constTerms[i] + this.getValue(res[i], knots.get(i + 1), knots.get(i)) - sum;
            sum = 0.0;
        }
        constTerms[indicator] = -this.getValue(res[indicator], initialKey, knots.get(indicator));
        for (i = indicator - 1; i > -1; --i) {
            constTerms[i] = constTerms[i + 1] - this.getValue(res[i], knots.get(i + 1), knots.get(i));
        }
        for (i = 0; i < rowCount; ++i) {
            res[i][nCoefs] = constTerms[i];
        }
        PiecewisePolynomialResult ppInt = new PiecewisePolynomialResult(pp.getKnots(), DoubleMatrix.copyOf((double[][])res), colCount, 1);
        return this.evaluate(ppInt, xKey).get(0);
    }

    public DoubleArray integrate(PiecewisePolynomialResult pp, double initialKey, double[] xKeys) {
        int i;
        ArgChecker.notNull((Object)pp, (String)"pp");
        ArgChecker.notNull((Object)xKeys, (String)"xKeys");
        ArgChecker.isFalse((boolean)Double.isNaN(initialKey), (String)"initialKey containing NaN");
        ArgChecker.isFalse((boolean)Double.isInfinite(initialKey), (String)"initialKey containing Infinity");
        ArgChecker.isTrue((pp.getDimensions() == 1 ? 1 : 0) != 0, (String)"Dimension should be 1");
        DoubleArray knots = pp.getKnots();
        int nCoefs = pp.getOrder();
        int nKnots = pp.getNumberOfIntervals() + 1;
        int rowCount = nKnots - 1;
        int colCount = nCoefs + 1;
        double[][] res = new double[rowCount][colCount];
        for (int i2 = 0; i2 < rowCount; ++i2) {
            for (int j = 0; j < nCoefs; ++j) {
                res[i2][j] = pp.getCoefMatrix().get(i2, j) / (double)(nCoefs - j);
            }
        }
        double[] constTerms = new double[rowCount];
        int indicator = 0;
        if (initialKey <= knots.get(1)) {
            indicator = 0;
        } else {
            for (int i3 = 1; i3 < rowCount; ++i3) {
                if (!(knots.get(i3) < initialKey)) continue;
                indicator = i3;
            }
        }
        double sum = this.getValue(res[indicator], initialKey, knots.get(indicator));
        for (i = indicator; i < nKnots - 2; ++i) {
            constTerms[i + 1] = constTerms[i] + this.getValue(res[i], knots.get(i + 1), knots.get(i)) - sum;
            sum = 0.0;
        }
        constTerms[indicator] = -this.getValue(res[indicator], initialKey, knots.get(indicator));
        for (i = indicator - 1; i > -1; --i) {
            constTerms[i] = constTerms[i + 1] - this.getValue(res[i], knots.get(i + 1), knots.get(i));
        }
        for (i = 0; i < rowCount; ++i) {
            res[i][nCoefs] = constTerms[i];
        }
        PiecewisePolynomialResult ppInt = new PiecewisePolynomialResult(pp.getKnots(), DoubleMatrix.copyOf((double[][])res), colCount, 1);
        return this.evaluate(ppInt, xKeys).row(0);
    }

    public ValueDerivatives evaluateAndDifferentiate(PiecewisePolynomialResult pp, double xKey) {
        ArgChecker.notNull((Object)pp, (String)"null pp");
        ArgChecker.isFalse((boolean)Double.isNaN(xKey), (String)"xKey containing NaN");
        ArgChecker.isFalse((boolean)Double.isInfinite(xKey), (String)"xKey containing Infinity");
        if (pp.getDimensions() > 1) {
            throw new UnsupportedOperationException();
        }
        DoubleArray knots = pp.getKnots();
        int nKnots = knots.size();
        int interval = FunctionUtils.getLowerBoundIndex(knots, xKey);
        if (interval == nKnots - 1) {
            --interval;
        }
        double s = xKey - knots.get(interval);
        DoubleArray coefs = pp.getCoefMatrix().row(interval);
        int nCoefs = coefs.size();
        double resValue = coefs.get(0);
        double resDeriv = coefs.get(0) * (double)(nCoefs - 1);
        for (int i = 1; i < nCoefs - 1; ++i) {
            resValue *= s;
            resDeriv *= s;
            resDeriv += coefs.get(i) * (double)(nCoefs - i - 1);
            ArgChecker.isFalse((boolean)Double.isInfinite(resValue += coefs.get(i)), (String)"Too large input");
            ArgChecker.isFalse((boolean)Double.isNaN(resValue), (String)"Too large input");
        }
        resValue *= s;
        return ValueDerivatives.of((double)(resValue += coefs.get(nCoefs - 1)), (DoubleArray)DoubleArray.of((double)resDeriv));
    }

    protected double getValue(DoubleArray coefs, double x, double leftknot) {
        return this.getValue(coefs.toArrayUnsafe(), x, leftknot);
    }

    protected double getValue(double[] coefs, double x, double leftknot) {
        int nCoefs = coefs.length;
        double s = x - leftknot;
        double res = coefs[0];
        for (int i = 1; i < nCoefs; ++i) {
            res *= s;
            res += coefs[i];
        }
        return res;
    }
}

