/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.function;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.math.impl.FunctionUtils;
import com.opengamma.strata.math.impl.function.PiecewisePolynomialFunction1D;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResultsWithSensitivity;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebra;
import com.opengamma.strata.math.impl.matrix.OGMatrixAlgebra;

public class PiecewisePolynomialWithSensitivityFunction1D
extends PiecewisePolynomialFunction1D {
    private static final MatrixAlgebra MA = new OGMatrixAlgebra();

    public DoubleArray nodeSensitivity(PiecewisePolynomialResultsWithSensitivity pp, double xKey) {
        ArgChecker.notNull((Object)pp, (String)"null pp");
        ArgChecker.isFalse((boolean)Double.isNaN(xKey), (String)"xKey containing NaN");
        ArgChecker.isFalse((boolean)Double.isInfinite(xKey), (String)"xKey containing Infinity");
        if (pp.getDimensions() > 1) {
            throw new UnsupportedOperationException();
        }
        DoubleArray knots = pp.getKnots();
        int nKnots = knots.size();
        int interval = FunctionUtils.getLowerBoundIndex(knots, xKey);
        if (interval == nKnots - 1) {
            --interval;
        }
        double s = xKey - knots.get(interval);
        DoubleMatrix a = pp.getCoefficientSensitivity(interval);
        int nCoefs = a.rowCount();
        DoubleArray res = a.row(0);
        for (int i = 1; i < nCoefs; ++i) {
            res = (DoubleArray)MA.scale((Matrix)res, s);
            res = (DoubleArray)MA.add((Matrix)res, (Matrix)a.row(i));
        }
        return res;
    }

    public DoubleArray[] nodeSensitivity(PiecewisePolynomialResultsWithSensitivity pp, double[] xKeys) {
        ArgChecker.notNull((Object)pp, (String)"null pp");
        ArgChecker.notNull((Object)xKeys, (String)"null xKeys");
        int nKeys = xKeys.length;
        DoubleArray[] res = new DoubleArray[nKeys];
        for (int i = 0; i < nKeys; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xKeys[i]), (String)"xKey containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xKeys[i]), (String)"xKey containing Infinity");
        }
        if (pp.getDimensions() > 1) {
            throw new UnsupportedOperationException();
        }
        DoubleArray knots = pp.getKnots();
        int nKnots = knots.size();
        for (int j = 0; j < nKeys; ++j) {
            double xKey = xKeys[j];
            int interval = FunctionUtils.getLowerBoundIndex(knots, xKey);
            if (interval == nKnots - 1) {
                --interval;
            }
            double s = xKey - knots.get(interval);
            DoubleMatrix a = pp.getCoefficientSensitivity(interval);
            int nCoefs = a.rowCount();
            res[j] = a.row(0);
            for (int i = 1; i < nCoefs; ++i) {
                res[j] = (DoubleArray)MA.scale((Matrix)res[j], s);
                res[j] = (DoubleArray)MA.add((Matrix)res[j], (Matrix)a.row(i));
            }
        }
        return res;
    }

    public DoubleArray differentiateNodeSensitivity(PiecewisePolynomialResultsWithSensitivity pp, double xKey) {
        ArgChecker.notNull((Object)pp, (String)"null pp");
        ArgChecker.isFalse((boolean)Double.isNaN(xKey), (String)"xKey containing NaN");
        ArgChecker.isFalse((boolean)Double.isInfinite(xKey), (String)"xKey containing Infinity");
        if (pp.getDimensions() > 1) {
            throw new UnsupportedOperationException();
        }
        int nCoefs = pp.getOrder();
        ArgChecker.isFalse((nCoefs < 2 ? 1 : 0) != 0, (String)"Polynomial degree is too low");
        DoubleArray knots = pp.getKnots();
        int nKnots = knots.size();
        int interval = FunctionUtils.getLowerBoundIndex(knots, xKey);
        if (interval == nKnots - 1) {
            --interval;
        }
        double s = xKey - knots.get(interval);
        DoubleMatrix a = pp.getCoefficientSensitivity(interval);
        DoubleArray res = (DoubleArray)MA.scale((Matrix)a.row(0), nCoefs - 1);
        for (int i = 1; i < nCoefs - 1; ++i) {
            res = (DoubleArray)MA.scale((Matrix)res, s);
            res = (DoubleArray)MA.add((Matrix)res, MA.scale((Matrix)a.row(i), nCoefs - 1 - i));
        }
        return res;
    }

    public DoubleArray[] differentiateNodeSensitivity(PiecewisePolynomialResultsWithSensitivity pp, double[] xKeys) {
        ArgChecker.notNull((Object)pp, (String)"null pp");
        if (pp.getDimensions() > 1) {
            throw new UnsupportedOperationException();
        }
        int nCoefs = pp.getOrder();
        ArgChecker.isFalse((nCoefs < 2 ? 1 : 0) != 0, (String)"Polynomial degree is too low");
        int nIntervals = pp.getNumberOfIntervals();
        DoubleMatrix[] diffSense = new DoubleMatrix[nIntervals];
        DoubleMatrix[] senseMat = pp.getCoefficientSensitivityAll();
        int nData = senseMat[0].columnCount();
        for (int i = 0; i < nIntervals; ++i) {
            double[][] senseMatArray = senseMat[i].toArray();
            double[][] tmp = new double[nCoefs - 1][nData];
            for (int j = 0; j < nCoefs - 1; ++j) {
                for (int k = 0; k < nData; ++k) {
                    tmp[j][k] = (double)(nCoefs - 1 - j) * senseMatArray[j][k];
                }
            }
            diffSense[i] = DoubleMatrix.copyOf((double[][])tmp);
        }
        PiecewisePolynomialResultsWithSensitivity ppDiff = new PiecewisePolynomialResultsWithSensitivity(pp.getKnots(), pp.getCoefMatrix(), nCoefs - 1, pp.getDimensions(), diffSense);
        return this.nodeSensitivity(ppDiff, xKeys);
    }

    public DoubleArray differentiateTwiceNodeSensitivity(PiecewisePolynomialResultsWithSensitivity pp, double xKey) {
        ArgChecker.notNull((Object)pp, (String)"null pp");
        ArgChecker.isFalse((boolean)Double.isNaN(xKey), (String)"xKey containing NaN");
        ArgChecker.isFalse((boolean)Double.isInfinite(xKey), (String)"xKey containing Infinity");
        if (pp.getDimensions() > 1) {
            throw new UnsupportedOperationException();
        }
        int nCoefs = pp.getOrder();
        ArgChecker.isFalse((nCoefs < 3 ? 1 : 0) != 0, (String)"Polynomial degree is too low");
        DoubleArray knots = pp.getKnots();
        int nKnots = knots.size();
        int interval = FunctionUtils.getLowerBoundIndex(knots, xKey);
        if (interval == nKnots - 1) {
            --interval;
        }
        double s = xKey - knots.get(interval);
        DoubleMatrix a = pp.getCoefficientSensitivity(interval);
        DoubleArray res = (DoubleArray)MA.scale((Matrix)a.row(0), (nCoefs - 1) * (nCoefs - 2));
        for (int i = 1; i < nCoefs - 2; ++i) {
            res = (DoubleArray)MA.scale((Matrix)res, s);
            res = (DoubleArray)MA.add((Matrix)res, MA.scale((Matrix)a.row(i), (nCoefs - 1 - i) * (nCoefs - 2 - i)));
        }
        return res;
    }

    public DoubleArray[] differentiateTwiceNodeSensitivity(PiecewisePolynomialResultsWithSensitivity pp, double[] xKeys) {
        ArgChecker.notNull((Object)pp, (String)"null pp");
        if (pp.getDimensions() > 1) {
            throw new UnsupportedOperationException();
        }
        int nCoefs = pp.getOrder();
        ArgChecker.isFalse((nCoefs < 3 ? 1 : 0) != 0, (String)"Polynomial degree is too low");
        int nIntervals = pp.getNumberOfIntervals();
        DoubleMatrix[] diffSense = new DoubleMatrix[nIntervals];
        DoubleMatrix[] senseMat = pp.getCoefficientSensitivityAll();
        int nData = senseMat[0].columnCount();
        for (int i = 0; i < nIntervals; ++i) {
            double[][] senseMatArray = senseMat[i].toArray();
            double[][] tmp = new double[nCoefs - 2][nData];
            for (int j = 0; j < nCoefs - 2; ++j) {
                for (int k = 0; k < nData; ++k) {
                    tmp[j][k] = (double)((nCoefs - 1 - j) * (nCoefs - 2 - j)) * senseMatArray[j][k];
                }
            }
            diffSense[i] = DoubleMatrix.copyOf((double[][])tmp);
        }
        PiecewisePolynomialResultsWithSensitivity ppDiff = new PiecewisePolynomialResultsWithSensitivity(pp.getKnots(), pp.getCoefMatrix(), nCoefs - 2, pp.getDimensions(), diffSense);
        return this.nodeSensitivity(ppDiff, xKeys);
    }
}

