/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.function.special;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.math.impl.function.DoubleFunction1D;
import com.opengamma.strata.math.impl.function.special.OrthogonalPolynomialFunctionGenerator;

public class HermitePolynomialFunction
extends OrthogonalPolynomialFunctionGenerator {
    private static final DoubleFunction1D TWO_X = x -> 2.0 * x;

    @Override
    public DoubleFunction1D[] getPolynomials(int n) {
        ArgChecker.isTrue((n >= 0 ? 1 : 0) != 0);
        DoubleFunction1D[] polynomials = new DoubleFunction1D[n + 1];
        for (int i = 0; i <= n; ++i) {
            polynomials[i] = i == 0 ? this.getOne() : (i == 1 ? TWO_X : polynomials[i - 1].multiply(2.0).multiply(this.getX()).subtract(polynomials[i - 2].multiply(2 * i - 2)));
        }
        return polynomials;
    }

    @Override
    public Pair<DoubleFunction1D, DoubleFunction1D>[] getPolynomialsAndFirstDerivative(int n) {
        throw new UnsupportedOperationException();
    }
}

