/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.function.special;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.MathException;
import java.util.function.Function;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.special.Beta;

public class IncompleteBetaFunction
implements Function<Double, Double> {
    private final double _a;
    private final double _b;
    private final double _eps;
    private final int _maxIter;

    public IncompleteBetaFunction(double a, double b) {
        this(a, b, 1.0E-12, 10000);
    }

    public IncompleteBetaFunction(double a, double b, double eps, int maxIter) {
        ArgChecker.isTrue((a > 0.0 ? 1 : 0) != 0, (String)"a must be > 0");
        ArgChecker.isTrue((b > 0.0 ? 1 : 0) != 0, (String)"b must be > 0");
        ArgChecker.isTrue((eps >= 0.0 ? 1 : 0) != 0, (String)"eps must not be negative");
        ArgChecker.isTrue((maxIter >= 1 ? 1 : 0) != 0, (String)"maximum number of iterations must be greater than zero");
        this._a = a;
        this._b = b;
        this._eps = eps;
        this._maxIter = maxIter;
    }

    @Override
    public Double apply(Double x) {
        ArgChecker.isTrue((x >= 0.0 && x <= 1.0 ? 1 : 0) != 0, (String)"x must be in the range 0 to 1");
        try {
            return Beta.regularizedBeta((double)x, (double)this._a, (double)this._b, (double)this._eps, (int)this._maxIter);
        }
        catch (MaxCountExceededException e) {
            throw new MathException(e);
        }
    }
}

