/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.function.special;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.MathException;
import java.util.function.Function;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.special.Gamma;

public class IncompleteGammaFunction
implements Function<Double, Double> {
    private final int _maxIter;
    private final double _eps;
    private final double _a;

    public IncompleteGammaFunction(double a) {
        ArgChecker.notNegativeOrZero((double)a, (String)"a");
        this._maxIter = 100000;
        this._eps = 1.0E-12;
        this._a = a;
    }

    public IncompleteGammaFunction(double a, int maxIter, double eps) {
        ArgChecker.notNegativeOrZero((double)a, (String)"a");
        ArgChecker.notNegative((double)eps, (String)"eps");
        if (maxIter < 1) {
            throw new IllegalArgumentException("Must have at least one iteration");
        }
        this._maxIter = maxIter;
        this._eps = eps;
        this._a = a;
    }

    @Override
    public Double apply(Double x) {
        try {
            return Gamma.regularizedGammaP((double)this._a, (double)x, (double)this._eps, (int)this._maxIter);
        }
        catch (MaxCountExceededException e) {
            throw new MathException(e);
        }
    }
}

