/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.function.special;

import com.google.common.math.DoubleMath;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.function.special.IncompleteBetaFunction;
import com.opengamma.strata.math.impl.function.special.NaturalLogGammaFunction;
import java.util.function.Function;

public class InverseIncompleteBetaFunction
implements Function<Double, Double> {
    private final double _a;
    private final double _b;
    private final Function<Double, Double> _lnGamma = new NaturalLogGammaFunction();
    private final Function<Double, Double> _beta;
    private static final double EPS = 1.0E-9;

    public InverseIncompleteBetaFunction(double a, double b) {
        ArgChecker.notNegativeOrZero((double)a, (String)"a");
        ArgChecker.notNegativeOrZero((double)b, (String)"b");
        this._a = a;
        this._b = b;
        this._beta = new IncompleteBetaFunction(a, b);
    }

    @Override
    public Double apply(Double x) {
        double u;
        double w;
        double p;
        double t;
        ArgChecker.inRangeInclusive((double)x, (double)0.0, (double)1.0, (String)"x");
        double a1 = this._a - 1.0;
        double b1 = this._b - 1.0;
        if (this._a >= 1.0 && this._b >= 1.0) {
            double pp = x < 0.5 ? x : 1.0 - x;
            t = Math.sqrt(-2.0 * Math.log(pp));
            p = (2.30753 + t * 0.27061) / (1.0 + t * (0.99229 + t * 0.04481)) - t;
            if (p < 0.5) {
                p *= -1.0;
            }
            a1 = (Math.sqrt(p) - 3.0) / 6.0;
            double tempA = 1.0 / (2.0 * this._a - 1.0);
            double tempB = 1.0 / (2.0 * this._b - 1.0);
            double h = 2.0 / (tempA + tempB);
            w = p * Math.sqrt(a1 + h) / h - (tempB - tempA) * (a1 + 0.8333333333333334 - 2.0 / (3.0 * h));
            p = this._a / (this._a + this._b + Math.exp(2.0 * w));
        } else {
            double lnA = Math.log(this._a / (this._a + this._b));
            double lnB = Math.log(this._b / (this._a + this._b));
            t = Math.exp(this._a * lnA) / this._a;
            u = Math.exp(this._b * lnB) / this._b;
            w = t + u;
            p = x < t / w ? Math.pow(this._a * w * x, 1.0 / this._a) : 1.0 - Math.pow(this._b * w * (1.0 - x), 1.0 / this._b);
        }
        double afac = -this._lnGamma.apply(this._a).doubleValue() - this._lnGamma.apply(this._b) + this._lnGamma.apply(this._a + this._b);
        for (int j = 0; j < 10; ++j) {
            if (DoubleMath.fuzzyEquals((double)p, (double)0.0, (double)1.0E-16) || DoubleMath.fuzzyEquals((double)p, (double)1.0, (double)1.0E-16)) {
                throw new MathException("a or b too small for accurate evaluation");
            }
            double error = this._beta.apply(p) - x;
            t = Math.exp(a1 * Math.log(p) + b1 * Math.log(1.0 - p) + afac);
            u = error / t;
            if ((p -= (t = u / (1.0 - 0.5 * Math.min(1.0, u * (a1 / p - b1 / (1.0 - p)))))) <= 0.0) {
                p = 0.5 * (p + t);
            }
            if (p >= 1.0) {
                p = 0.5 * (p + t + 1.0);
            }
            if (Math.abs(t) < 1.0E-9 * p && j > 0) break;
        }
        return p;
    }
}

