/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.function.special;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.function.special.IncompleteGammaFunction;
import com.opengamma.strata.math.impl.function.special.NaturalLogGammaFunction;
import java.util.function.DoubleBinaryOperator;
import java.util.function.Function;

public class InverseIncompleteGammaFunction
implements DoubleBinaryOperator {
    private final Function<Double, Double> _lnGamma = new NaturalLogGammaFunction();
    private static final double EPS = 1.0E-8;

    @Override
    public double applyAsDouble(double a, double p) {
        double x;
        double t;
        ArgChecker.notNegativeOrZero((double)a, (String)"a");
        ArgChecker.inRangeExclusive((double)p, (double)0.0, (double)1.0, (String)"p");
        double lna1 = 0.0;
        double afac = 0.0;
        double a1 = a - 1.0;
        IncompleteGammaFunction gammaIncomplete = new IncompleteGammaFunction(a);
        double gln = this._lnGamma.apply(a);
        if (a > 1.0) {
            lna1 = Math.log(a1);
            afac = Math.exp(a1 * (lna1 - 1.0) - gln);
            double pp = p < 0.5 ? p : 1.0 - p;
            t = Math.sqrt(-2.0 * Math.log(pp));
            x = (2.30753 + t * 0.27061) / (1.0 + t * (0.99229 + t * 0.04481)) - t;
            if (p < 0.5) {
                x = -x;
            }
            x = Math.max(0.001, a * Math.pow(1.0 - 1.0 / (9.0 * a) - x / (3.0 * Math.sqrt(a)), 3.0));
        } else {
            t = 1.0 - a * (0.253 + a * 0.12);
            x = p < t ? Math.pow(p / t, 1.0 / a) : 1.0 - Math.log(1.0 - (p - t) / (1.0 - t));
        }
        for (int i = 0; i < 12; ++i) {
            if (x <= 0.0) {
                return 0.0;
            }
            double err = (Double)gammaIncomplete.apply(x) - p;
            t = a > 1.0 ? afac * Math.exp(-(x - a1) + a1 * (Math.log(x) - lna1)) : Math.exp(-x + a1 * Math.log(x) - gln);
            double u = err / t;
            if ((x -= (t = u / (1.0 - 0.5 * Math.min(1.0, u * ((a - 1.0) / x - 1.0))))) <= 0.0) {
                x = 0.05 * (x + t);
            }
            if (Math.abs(t) < 1.0E-8 * x) break;
        }
        return x;
    }
}

