/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.function.special;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.math.impl.function.DoubleFunction1D;
import com.opengamma.strata.math.impl.function.RealPolynomialFunction1D;
import com.opengamma.strata.math.impl.function.special.OrthogonalPolynomialFunctionGenerator;

public class JacobiPolynomialFunction
extends OrthogonalPolynomialFunctionGenerator {
    @Override
    public DoubleFunction1D[] getPolynomials(int n) {
        throw new UnsupportedOperationException("Need values for alpha and beta for Jacobi polynomial function generation");
    }

    @Override
    public Pair<DoubleFunction1D, DoubleFunction1D>[] getPolynomialsAndFirstDerivative(int n) {
        throw new UnsupportedOperationException("Need values for alpha and beta for Jacobi polynomial function generation");
    }

    public DoubleFunction1D[] getPolynomials(int n, double alpha, double beta) {
        ArgChecker.isTrue((n >= 0 ? 1 : 0) != 0);
        DoubleFunction1D[] polynomials = new DoubleFunction1D[n + 1];
        for (int i = 0; i <= n; ++i) {
            if (i == 0) {
                polynomials[i] = this.getOne();
                continue;
            }
            if (i == 1) {
                polynomials[i] = new RealPolynomialFunction1D((alpha - beta) / 2.0, (alpha + beta + 2.0) / 2.0);
                continue;
            }
            int j = i - 1;
            polynomials[i] = polynomials[j].multiply(this.getB(alpha, beta, j)).add(polynomials[j].multiply(this.getX()).multiply(this.getC(alpha, beta, j)).add(polynomials[j - 1].multiply(this.getD(alpha, beta, j)))).divide(this.getA(alpha, beta, j));
        }
        return polynomials;
    }

    public Pair<DoubleFunction1D, DoubleFunction1D>[] getPolynomialsAndFirstDerivative(int n, double alpha, double beta) {
        ArgChecker.isTrue((n >= 0 ? 1 : 0) != 0);
        Pair[] polynomials = new Pair[n + 1];
        for (int i = 0; i <= n; ++i) {
            if (i == 0) {
                polynomials[i] = Pair.of((Object)this.getOne(), (Object)this.getZero());
                continue;
            }
            if (i == 1) {
                double a1 = (alpha + beta + 2.0) / 2.0;
                polynomials[i] = Pair.of((Object)new RealPolynomialFunction1D((alpha - beta) / 2.0, a1), (Object)new RealPolynomialFunction1D(a1));
                continue;
            }
            int j = i - 1;
            DoubleFunction1D p1 = (DoubleFunction1D)polynomials[j].getFirst();
            DoubleFunction1D p2 = (DoubleFunction1D)polynomials[j - 1].getFirst();
            DoubleFunction1D temp1 = p1.multiply(this.getB(alpha, beta, j));
            DoubleFunction1D temp2 = p1.multiply(this.getX()).multiply(this.getC(alpha, beta, j));
            DoubleFunction1D temp3 = p2.multiply(this.getD(alpha, beta, j));
            DoubleFunction1D p = temp1.add(temp2).add(temp3).divide(this.getA(alpha, beta, j));
            DoubleFunction1D dp = p.derivative();
            polynomials[i] = Pair.of((Object)p, (Object)dp);
        }
        return polynomials;
    }

    private double getA(double alpha, double beta, int n) {
        return (double)(2 * (n + 1)) * ((double)n + alpha + beta + 1.0) * ((double)(2 * n) + alpha + beta);
    }

    private double getB(double alpha, double beta, int n) {
        return ((double)(2 * n) + alpha + beta + 1.0) * (alpha * alpha - beta * beta);
    }

    private double getC(double alpha, double beta, int n) {
        double x = (double)(2 * n) + alpha + beta;
        return x * (x + 1.0) * (x + 2.0);
    }

    private double getD(double alpha, double beta, int n) {
        return -2.0 * ((double)n + alpha) * ((double)n + beta) * ((double)(2 * n) + alpha + beta + 2.0);
    }
}

