/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.function.special;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.math.impl.function.DoubleFunction1D;
import com.opengamma.strata.math.impl.function.RealPolynomialFunction1D;
import com.opengamma.strata.math.impl.function.special.OrthogonalPolynomialFunctionGenerator;

public class OrthonormalHermitePolynomialFunction
extends OrthogonalPolynomialFunctionGenerator {
    private static final double C1 = 1.0 / Math.pow(Math.PI, 0.25);
    private static final double C2 = Math.sqrt(2.0) * C1;
    private static final RealPolynomialFunction1D F0 = new RealPolynomialFunction1D(C1);
    private static final RealPolynomialFunction1D DF1 = new RealPolynomialFunction1D(C2);

    @Override
    public DoubleFunction1D[] getPolynomials(int n) {
        ArgChecker.isTrue((n >= 0 ? 1 : 0) != 0);
        DoubleFunction1D[] polynomials = new DoubleFunction1D[n + 1];
        for (int i = 0; i <= n; ++i) {
            polynomials[i] = i == 0 ? F0 : (i == 1 ? polynomials[0].multiply(Math.sqrt(2.0)).multiply(this.getX()) : polynomials[i - 1].multiply(this.getX()).multiply(Math.sqrt(2.0 / (double)i)).subtract(polynomials[i - 2].multiply(Math.sqrt(((double)i - 1.0) / (double)i))));
        }
        return polynomials;
    }

    @Override
    public Pair<DoubleFunction1D, DoubleFunction1D>[] getPolynomialsAndFirstDerivative(int n) {
        ArgChecker.isTrue((n >= 0 ? 1 : 0) != 0);
        Pair[] polynomials = new Pair[n + 1];
        double sqrt2 = Math.sqrt(2.0);
        DoubleFunction1D x = this.getX();
        for (int i = 0; i <= n; ++i) {
            if (i == 0) {
                polynomials[i] = Pair.of((Object)F0, (Object)this.getZero());
                continue;
            }
            if (i == 1) {
                polynomials[i] = Pair.of((Object)((DoubleFunction1D)polynomials[0].getFirst()).multiply(sqrt2).multiply(x), (Object)DF1);
                continue;
            }
            DoubleFunction1D p1 = (DoubleFunction1D)polynomials[i - 1].getFirst();
            DoubleFunction1D p2 = (DoubleFunction1D)polynomials[i - 2].getFirst();
            DoubleFunction1D p = p1.multiply(x).multiply(Math.sqrt(2.0 / (double)i)).subtract(p2.multiply(Math.sqrt(((double)i - 1.0) / (double)i)));
            DoubleFunction1D dp = p1.multiply(Math.sqrt(2 * i));
            polynomials[i] = Pair.of((Object)p, (Object)dp);
        }
        return polynomials;
    }
}

