/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.function.special;

import com.opengamma.strata.collect.ArgChecker;
import java.util.function.Function;

public class TopHatFunction
implements Function<Double, Double> {
    private final double _x1;
    private final double _x2;
    private final double _y;

    public TopHatFunction(double x1, double x2, double y) {
        ArgChecker.isTrue((x1 < x2 ? 1 : 0) != 0, (String)"x1 must be less than x2");
        this._x1 = x1;
        this._x2 = x2;
        this._y = y;
    }

    @Override
    public Double apply(Double x) {
        ArgChecker.notNull((Object)x, (String)"x");
        ArgChecker.isTrue((x != this._x1 ? 1 : 0) != 0, (String)"Function is undefined for x = x1");
        ArgChecker.isTrue((x != this._x2 ? 1 : 0) != 0, (String)"Function is undefined for x = x2");
        if (x > this._x1 && x < this._x2) {
            return this._y;
        }
        return 0.0;
    }
}

