/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.integration;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.integration.Integrator1D;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptiveCompositeIntegrator1D
extends Integrator1D<Double, Double> {
    private static final Logger log = LoggerFactory.getLogger(AdaptiveCompositeIntegrator1D.class);
    private final Integrator1D<Double, Double> integrator;
    private static final int MAX_IT = 15;
    private final double gain;
    private final double tol;

    public AdaptiveCompositeIntegrator1D(Integrator1D<Double, Double> integrator) {
        ArgChecker.notNull(integrator, (String)"integrator");
        this.integrator = integrator;
        this.gain = 15.0;
        this.tol = 1.0E-13;
    }

    public AdaptiveCompositeIntegrator1D(Integrator1D<Double, Double> integrator, double gain, double tol) {
        ArgChecker.notNull(integrator, (String)"integrator");
        this.integrator = integrator;
        this.gain = gain;
        this.tol = tol;
    }

    @Override
    public Double integrate(Function<Double, Double> f, Double lower, Double upper) {
        ArgChecker.notNull(f, (String)"f");
        ArgChecker.notNull((Object)lower, (String)"lower bound");
        ArgChecker.notNull((Object)upper, (String)"upper bound");
        try {
            if (lower < upper) {
                return this.integration(f, lower, upper);
            }
            log.info("Upper bound was less than lower bound; swapping bounds and negating result");
            return -this.integration(f, upper, lower).doubleValue();
        }
        catch (Exception e) {
            throw new IllegalStateException("function evaluation returned NaN or Inf");
        }
    }

    private Double integration(Function<Double, Double> f, Double lower, Double upper) {
        double res = this.integrator.integrate(f, lower, upper);
        return this.integrationRec(f, lower, upper, res, 15.0);
    }

    private double integrationRec(Function<Double, Double> f, double lower, double upper, double res, double counter) {
        double localTol = this.gain * this.tol;
        double half = 0.5 * (lower + upper);
        double newResDw = this.integrator.integrate(f, lower, half);
        double newResUp = this.integrator.integrate(f, half, upper);
        double newRes = newResUp + newResDw;
        if (Math.abs(res - newRes) < localTol || counter == 0.0 || Math.abs(res) < 1.0E-14 && Math.abs(newResUp) < 1.0E-14 && Math.abs(newResDw) < 1.0E-14) {
            return newRes + (newRes - res) / this.gain;
        }
        return this.integrationRec(f, lower, half, newResDw, counter - 1.0) + this.integrationRec(f, half, upper, newResUp, counter - 1.0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.gain);
        result = prime * result + (int)(temp ^ temp >>> 32);
        result = prime * result + this.integrator.hashCode();
        temp = Double.doubleToLongBits(this.tol);
        result = prime * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdaptiveCompositeIntegrator1D)) {
            return false;
        }
        AdaptiveCompositeIntegrator1D other = (AdaptiveCompositeIntegrator1D)obj;
        if (Double.doubleToLongBits(this.gain) != Double.doubleToLongBits(other.gain)) {
            return false;
        }
        if (!this.integrator.equals(other.integrator)) {
            return false;
        }
        return Double.doubleToLongBits(this.tol) == Double.doubleToLongBits(other.tol);
    }
}

