/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.integration;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.integration.Integrator1D;
import com.opengamma.strata.math.impl.util.CommonsMathWrapper;
import java.util.function.Function;
import org.apache.commons.math3.analysis.integration.TrapezoidIntegrator;
import org.apache.commons.math3.analysis.integration.UnivariateIntegrator;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedTrapezoidIntegrator1D
extends Integrator1D<Double, Double> {
    private static final Logger log = LoggerFactory.getLogger(ExtendedTrapezoidIntegrator1D.class);
    private static final UnivariateIntegrator INTEGRATOR = new TrapezoidIntegrator();
    private static final int MAX_EVAL = 10000;

    @Override
    public Double integrate(Function<Double, Double> f, Double lower, Double upper) {
        ArgChecker.notNull(f, (String)"f");
        ArgChecker.notNull((Object)lower, (String)"lower");
        ArgChecker.notNull((Object)upper, (String)"upper");
        try {
            if (lower < upper) {
                return INTEGRATOR.integrate(10000, CommonsMathWrapper.wrapUnivariate(f), lower.doubleValue(), upper.doubleValue());
            }
            log.info("Upper bound was less than lower bound; swapping bounds and negating result");
            return -INTEGRATOR.integrate(10000, CommonsMathWrapper.wrapUnivariate(f), upper.doubleValue(), lower.doubleValue());
        }
        catch (MathIllegalArgumentException | MaxCountExceededException e) {
            throw new MathException(e);
        }
    }
}

