/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.integration;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.integration.GaussJacobiWeightAndAbscissaFunction;
import com.opengamma.strata.math.impl.integration.GaussianQuadratureIntegrator1D;
import java.util.function.Function;

public class GaussJacobiQuadratureIntegrator1D
extends GaussianQuadratureIntegrator1D {
    private static final GaussJacobiWeightAndAbscissaFunction GENERATOR = new GaussJacobiWeightAndAbscissaFunction(0.0, 0.0);
    private static final Double[] LIMITS = new Double[]{-1.0, 1.0};

    public GaussJacobiQuadratureIntegrator1D(int n) {
        super(n, GENERATOR);
    }

    @Override
    public Double[] getLimits() {
        return LIMITS;
    }

    @Override
    public Function<Double, Double> getIntegralFunction(final Function<Double, Double> function, Double lower, Double upper) {
        ArgChecker.notNull(function, (String)"function");
        ArgChecker.notNull((Object)lower, (String)"lower");
        ArgChecker.notNull((Object)upper, (String)"upper");
        final double m = (upper - lower) / 2.0;
        final double c = (upper + lower) / 2.0;
        return new Function<Double, Double>(){

            @Override
            public Double apply(Double x) {
                return m * (Double)function.apply(m * x + c);
            }
        };
    }
}

