/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.integration;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.math.impl.function.DoubleFunction1D;
import com.opengamma.strata.math.impl.function.special.GammaFunction;
import com.opengamma.strata.math.impl.function.special.JacobiPolynomialFunction;
import com.opengamma.strata.math.impl.integration.GaussianQuadratureData;
import com.opengamma.strata.math.impl.integration.QuadratureWeightAndAbscissaFunction;
import com.opengamma.strata.math.impl.rootfinding.NewtonRaphsonSingleRootFinder;
import java.util.function.DoubleUnaryOperator;
import org.apache.commons.math3.util.CombinatoricsUtils;

public class GaussJacobiWeightAndAbscissaFunction
implements QuadratureWeightAndAbscissaFunction {
    private static final JacobiPolynomialFunction JACOBI = new JacobiPolynomialFunction();
    private static final NewtonRaphsonSingleRootFinder ROOT_FINDER = new NewtonRaphsonSingleRootFinder(1.0E-12);
    private static final DoubleUnaryOperator GAMMA_FUNCTION = new GammaFunction();
    private final double _alpha;
    private final double _beta;
    private final double _c;

    public GaussJacobiWeightAndAbscissaFunction() {
        this(0.0, 0.0);
    }

    public GaussJacobiWeightAndAbscissaFunction(double alpha, double beta) {
        this._alpha = alpha;
        this._beta = beta;
        this._c = this._alpha + this._beta;
    }

    @Override
    public GaussianQuadratureData generate(int n) {
        ArgChecker.isTrue((n > 0 ? 1 : 0) != 0, (String)"n > 0");
        Pair<DoubleFunction1D, DoubleFunction1D>[] polynomials = JACOBI.getPolynomialsAndFirstDerivative(n, this._alpha, this._beta);
        Pair<DoubleFunction1D, DoubleFunction1D> pair = polynomials[n];
        DoubleFunction1D previous = (DoubleFunction1D)polynomials[n - 1].getFirst();
        DoubleFunction1D function = (DoubleFunction1D)pair.getFirst();
        DoubleFunction1D derivative = (DoubleFunction1D)pair.getSecond();
        double[] x = new double[n];
        double[] w = new double[n];
        double root = 0.0;
        for (int i = 0; i < n; ++i) {
            double d = (double)(2 * n) + this._c;
            root = this.getInitialRootGuess(root, i, n, x);
            x[i] = root = ROOT_FINDER.getRoot(function, derivative, (Double)root).doubleValue();
            w[i] = GAMMA_FUNCTION.applyAsDouble(this._alpha + (double)n) * GAMMA_FUNCTION.applyAsDouble(this._beta + (double)n) / CombinatoricsUtils.factorialDouble((int)n) / GAMMA_FUNCTION.applyAsDouble((double)n + this._c + 1.0) * d * Math.pow(2.0, this._c) / (derivative.applyAsDouble(root) * previous.applyAsDouble(root));
        }
        return new GaussianQuadratureData(x, w);
    }

    private double getInitialRootGuess(double previousRoot, int i, int n, double[] x) {
        if (i == 0) {
            double a = this._alpha / (double)n;
            double b = this._beta / (double)n;
            double x1 = (1.0 + this._alpha) * (2.78 / (double)(4 + n * n) + 0.768 * a / (double)n);
            double x2 = 1.0 + 1.48 * a + 0.96 * b + 0.452 * a * a + 0.83 * a * b;
            return 1.0 - x1 / x2;
        }
        if (i == 1) {
            double x1 = (4.1 + this._alpha) / ((1.0 + this._alpha) * (1.0 + 0.156 * this._alpha));
            double x2 = 1.0 + 0.06 * (double)(n - 8) * (1.0 + 0.12 * this._alpha) / (double)n;
            double x3 = 1.0 + 0.012 * this._beta * (1.0 + 0.25 * Math.abs(this._alpha)) / (double)n;
            return previousRoot - (1.0 - previousRoot) * x1 * x2 * x3;
        }
        if (i == 2) {
            double x1 = (1.67 + 0.28 * this._alpha) / (1.0 + 0.37 * this._alpha);
            double x2 = 1.0 + 0.22 * (double)(n - 8) / (double)n;
            double x3 = 1.0 + 8.0 * this._beta / ((6.28 + this._beta) * (double)n * (double)n);
            return previousRoot - (x[0] - previousRoot) * x1 * x2 * x3;
        }
        if (i == n - 2) {
            double x1 = (1.0 + 0.235 * this._beta) / (0.766 + 0.119 * this._beta);
            double x2 = 1.0 / (1.0 + 0.639 * ((double)n - 4.0) / (1.0 + 0.71 * ((double)n - 4.0)));
            double x3 = 1.0 / (1.0 + 20.0 * this._alpha / ((7.5 + this._alpha) * (double)n * (double)n));
            return previousRoot + (previousRoot - x[n - 4]) * x1 * x2 * x3;
        }
        if (i == n - 1) {
            double x1 = (1.0 + 0.37 * this._beta) / (1.67 + 0.28 * this._beta);
            double x2 = 1.0 / (1.0 + 0.22 * ((double)n - 8.0) / (double)n);
            double x3 = 1.0 / (1.0 + 8.0 * this._alpha / ((6.28 + this._alpha) * (double)n * (double)n));
            return previousRoot + (previousRoot - x[n - 3]) * x1 * x2 * x3;
        }
        return 3.0 * x[i - 1] - 3.0 * x[i - 2] + x[i - 3];
    }
}

