/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.integration;

import com.opengamma.strata.collect.ArgChecker;
import java.util.Arrays;

public class GaussianQuadratureData {
    private final double[] _weights;
    private final double[] _abscissas;

    public GaussianQuadratureData(double[] abscissas, double[] weights) {
        ArgChecker.notNull((Object)abscissas, (String)"abscissas");
        ArgChecker.notNull((Object)weights, (String)"weights");
        ArgChecker.isTrue((abscissas.length == weights.length ? 1 : 0) != 0, (String)"Abscissa and weight arrays must be the same length");
        this._weights = weights;
        this._abscissas = abscissas;
    }

    public double[] getWeights() {
        return this._weights;
    }

    public double[] getAbscissas() {
        return this._abscissas;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this._abscissas);
        result = prime * result + Arrays.hashCode(this._weights);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GaussianQuadratureData other = (GaussianQuadratureData)obj;
        if (!Arrays.equals(this._abscissas, other._abscissas)) {
            return false;
        }
        return Arrays.equals(this._weights, other._weights);
    }
}

