/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.integration;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.integration.Integrator;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Integrator1D<T, U>
implements Integrator<T, U, Function<U, T>> {
    private static final Logger log = LoggerFactory.getLogger(Integrator1D.class);

    @Override
    public T integrate(Function<U, T> f, U[] lower, U[] upper) {
        ArgChecker.notNull(f, (String)"function was null");
        ArgChecker.notNull(lower, (String)"lower bound array was null");
        ArgChecker.notNull(upper, (String)"upper bound array was null");
        ArgChecker.notEmpty((Object[])lower, (String)"lower bound array was empty");
        ArgChecker.notEmpty((Object[])upper, (String)"upper bound array was empty");
        ArgChecker.notNull(lower[0], (String)"lower bound was null");
        ArgChecker.notNull(upper[0], (String)"upper bound was null");
        if (lower.length > 1) {
            log.info("Lower bound array had more than one element; only using the first");
        }
        if (upper.length > 1) {
            log.info("Upper bound array had more than one element; only using the first");
        }
        return this.integrate(f, lower[0], upper[0]);
    }

    public abstract T integrate(Function<U, T> var1, U var2, U var3);
}

