/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.integration;

import com.opengamma.strata.math.impl.integration.ExtendedTrapezoidIntegrator1D;
import com.opengamma.strata.math.impl.integration.Integrator1D;
import com.opengamma.strata.math.impl.integration.RombergIntegrator1D;
import com.opengamma.strata.math.impl.integration.SimpsonIntegrator1D;
import java.util.HashMap;
import java.util.Map;

public final class RealFunctionIntegrator1DFactory {
    public static final String ROMBERG = "Romberg";
    public static final RombergIntegrator1D ROMBERG_INSTANCE = new RombergIntegrator1D();
    public static final String SIMPSON = "Simpson";
    public static final SimpsonIntegrator1D SIMPSON_INSTANCE = new SimpsonIntegrator1D();
    public static final String EXTENDED_TRAPEZOID = "ExtendedTrapezoid";
    public static final ExtendedTrapezoidIntegrator1D EXTENDED_TRAPEZOID_INSTANCE = new ExtendedTrapezoidIntegrator1D();
    private static final Map<String, Integrator1D<Double, Double>> STATIC_INSTANCES;
    private static final Map<Class<?>, String> INSTANCE_NAMES;

    private RealFunctionIntegrator1DFactory() {
    }

    public static Integrator1D<Double, Double> getIntegrator(String integratorName) {
        Integrator1D<Double, Double> integrator = STATIC_INSTANCES.get(integratorName);
        if (integrator != null) {
            return integrator;
        }
        throw new IllegalArgumentException("Integrator " + integratorName + " not handled");
    }

    public static String getIntegratorName(Integrator1D<Double, Double> integrator) {
        if (integrator == null) {
            return null;
        }
        return INSTANCE_NAMES.get(integrator.getClass());
    }

    static {
        HashMap<String, Integrator1D> staticInstances = new HashMap<String, Integrator1D>();
        HashMap instanceNames = new HashMap();
        staticInstances.put(ROMBERG, ROMBERG_INSTANCE);
        instanceNames.put(ROMBERG_INSTANCE.getClass(), ROMBERG);
        staticInstances.put(SIMPSON, SIMPSON_INSTANCE);
        instanceNames.put(SIMPSON_INSTANCE.getClass(), SIMPSON);
        staticInstances.put(EXTENDED_TRAPEZOID, EXTENDED_TRAPEZOID_INSTANCE);
        instanceNames.put(EXTENDED_TRAPEZOID_INSTANCE.getClass(), EXTENDED_TRAPEZOID);
        STATIC_INSTANCES = new HashMap<String, Integrator1D<Double, Double>>(staticInstances);
        INSTANCE_NAMES = new HashMap(instanceNames);
    }
}

