/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.tuple.Pair;
import java.util.List;
import java.util.function.Function;

public class BasisFunctionAggregation<T>
implements Function<T, Double> {
    private final List<Function<T, Double>> _f;
    private final double[] _w;

    public BasisFunctionAggregation(List<Function<T, Double>> functions, double[] weights) {
        ArgChecker.notEmpty(functions, (String)"no functions");
        ArgChecker.notNull((Object)weights, (String)"no weights");
        ArgChecker.isTrue((functions.size() == weights.length ? 1 : 0) != 0);
        this._f = functions;
        this._w = (double[])weights.clone();
    }

    @Override
    public Double apply(T x) {
        ArgChecker.notNull(x, (String)"x");
        double sum = 0.0;
        int n = this._w.length;
        for (int i = 0; i < n; ++i) {
            double temp = this._f.get(i).apply(x);
            if (temp == 0.0) continue;
            sum += this._w[i] * temp;
        }
        return sum;
    }

    public DoubleArray weightSensitivity(T x) {
        ArgChecker.notNull(x, (String)"x");
        return DoubleArray.of((int)this._w.length, i -> this._f.get(i).apply(x));
    }

    public Pair<Double, DoubleArray> valueAndWeightSensitivity(T x) {
        ArgChecker.notNull(x, (String)"x");
        int n = this._w.length;
        double sum = 0.0;
        double[] data = new double[n];
        for (int i = 0; i < n; ++i) {
            double temp = this._f.get(i).apply(x);
            if (temp == 0.0) continue;
            sum += this._w[i] * temp;
            data[i] = temp;
        }
        return Pair.of((Object)sum, (Object)DoubleArray.ofUnsafe((double[])data));
    }
}

