/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.ArgChecker;

public final class BasisFunctionKnots {
    private final double[] _knots;
    private final int _degree;
    private final int _nSplines;

    public static BasisFunctionKnots fromUniform(double xa, double xb, int nKnots, int degree) {
        int i;
        ArgChecker.isTrue((xb > xa ? 1 : 0) != 0, (String)"Require xb > xa, values are xa = {}, xb = {}", (Object[])new Object[]{xa, xb});
        ArgChecker.notNegative((int)degree, (String)"degree");
        ArgChecker.isTrue((nKnots - degree > 0 ? 1 : 0) != 0, (String)"Require at least {} knots for degree {}, only given {}", (Object[])new Object[]{degree + 1, degree, nKnots});
        int nTotalKnots = nKnots + 2 * degree;
        int nSplines = nKnots + degree - 1;
        double[] knots = new double[nTotalKnots];
        double dx = (xb - xa) / (double)(nKnots - 1);
        for (i = 0; i < degree; ++i) {
            knots[i] = (double)(i - degree) * dx + xa;
            knots[degree + nKnots + i] = xb + dx * (double)(i + 1);
        }
        for (i = 0; i < nKnots - 1; ++i) {
            knots[i + degree] = xa + (double)i * dx;
        }
        knots[nKnots + degree - 1] = xb;
        return new BasisFunctionKnots(knots, degree, nSplines);
    }

    public static BasisFunctionKnots fromInternalKnots(double[] internalKnots, int degree) {
        ArgChecker.notEmpty((double[])internalKnots, (String)"knots");
        ArgChecker.notNegative((int)degree, (String)"degree");
        int nInterKnots = internalKnots.length;
        ArgChecker.isTrue((nInterKnots - degree > 0 ? 1 : 0) != 0, (String)"Require at least {} knots for degree {}, only given {}", (Object[])new Object[]{degree + 1, degree, nInterKnots});
        for (int i = 1; i < nInterKnots; ++i) {
            ArgChecker.isTrue((internalKnots[i] - internalKnots[i - 1] > 0.0 ? 1 : 0) != 0, (String)"knots are not ascending");
        }
        int nSplines = nInterKnots + degree - 1;
        int nTotalKnots = nInterKnots + 2 * degree;
        double[] knots = new double[nTotalKnots];
        double dxa = internalKnots[1] - internalKnots[0];
        double dxb = internalKnots[nInterKnots - 1] - internalKnots[nInterKnots - 2];
        for (int i = 0; i < degree; ++i) {
            knots[i] = (double)(i - degree) * dxa + internalKnots[0];
            knots[degree + nInterKnots + i] = internalKnots[nInterKnots - 1] + dxb * (double)(i + 1);
        }
        System.arraycopy(internalKnots, 0, knots, degree, nInterKnots);
        return new BasisFunctionKnots(knots, degree, nSplines);
    }

    public static BasisFunctionKnots fromKnots(double[] knots, int degree) {
        ArgChecker.notEmpty((double[])knots, (String)"knots");
        ArgChecker.notNegative((int)degree, (String)"degree");
        int nKnots = knots.length;
        ArgChecker.isTrue((nKnots - 3 * degree > 0 ? 1 : 0) != 0, (String)"Require at least {} knots for degree {}, only given {}", (Object[])new Object[]{3 * degree + 1, degree, nKnots});
        for (int i = 1; i < nKnots; ++i) {
            ArgChecker.isTrue((knots[i] - knots[i - 1] > 0.0 ? 1 : 0) != 0, (String)"knots are not ascending");
        }
        int nSplines = nKnots - degree - 1;
        return new BasisFunctionKnots(knots, degree, nSplines);
    }

    private BasisFunctionKnots(double[] knots, int degree, int nSplines) {
        this._knots = knots;
        this._degree = degree;
        this._nSplines = nSplines;
    }

    public double[] getKnots() {
        return (double[])this._knots.clone();
    }

    public int getNumKnots() {
        return this._knots.length;
    }

    public int getDegree() {
        return this._degree;
    }

    public int getNumSplines() {
        return this._nSplines;
    }
}

