/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.math.impl.function.PiecewisePolynomialFunction1D;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialInterpolator;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialInterpolator2D;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult2D;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebraFactory;

public class BicubicSplineInterpolator
extends PiecewisePolynomialInterpolator2D {
    private static final double ERROR = 1.0E-13;
    private PiecewisePolynomialInterpolator[] _method;
    private static DoubleMatrix INV_MAT;

    public BicubicSplineInterpolator(PiecewisePolynomialInterpolator[] method) {
        ArgChecker.notNull((Object)method, (String)"method");
        ArgChecker.isTrue((method.length == 2 ? 1 : 0) != 0, (String)"two methods should be chosen");
        this._method = new PiecewisePolynomialInterpolator[2];
        for (int i = 0; i < 2; ++i) {
            this._method[i] = method[i];
        }
    }

    public BicubicSplineInterpolator(PiecewisePolynomialInterpolator method) {
        this._method = new PiecewisePolynomialInterpolator[]{method, method};
    }

    @Override
    public PiecewisePolynomialResult2D interpolate(double[] x0Values, double[] x1Values, double[][] yValues) {
        ArgChecker.notNull((Object)x0Values, (String)"x0Values");
        ArgChecker.notNull((Object)x1Values, (String)"x1Values");
        ArgChecker.notNull((Object)yValues, (String)"yValues");
        int nData0 = x0Values.length;
        int nData1 = x1Values.length;
        DoubleMatrix yValuesMatrix = DoubleMatrix.copyOf((double[][])yValues);
        PiecewisePolynomialFunction1D func = new PiecewisePolynomialFunction1D();
        double[][] diff0 = new double[nData1][nData0];
        double[][] diff1 = new double[nData0][nData1];
        double[][] cross = new double[nData0][nData1];
        PiecewisePolynomialResult result0 = this._method[0].interpolate(x0Values, MatrixAlgebraFactory.OG_ALGEBRA.getTranspose((Matrix)yValuesMatrix).toArray());
        diff0 = func.differentiate(result0, x0Values).toArray();
        PiecewisePolynomialResult result1 = this._method[1].interpolate(x1Values, yValuesMatrix.toArray());
        diff1 = func.differentiate(result1, x1Values).toArray();
        int order = 4;
        for (int i = 0; i < nData0; ++i) {
            for (int j = 0; j < nData1; ++j) {
                if (yValues[i][j] == 0.0) {
                    if (diff0[j][i] == 0.0) {
                        cross[i][j] = diff1[i][j];
                        continue;
                    }
                    if (diff1[i][j] == 0.0) {
                        cross[i][j] = diff0[j][i];
                        continue;
                    }
                    cross[i][j] = Math.signum(diff0[j][i] * diff1[i][j]) * Math.sqrt(Math.abs(diff0[j][i] * diff1[i][j]));
                    continue;
                }
                cross[i][j] = diff0[j][i] * diff1[i][j] / yValues[i][j];
            }
        }
        DoubleMatrix[][] coefMat = new DoubleMatrix[nData0 - 1][nData1 - 1];
        for (int i = 0; i < nData0 - 1; ++i) {
            for (int j = 0; j < nData1 - 1; ++j) {
                int m;
                int l;
                double[] diffsVec = new double[16];
                for (l = 0; l < 2; ++l) {
                    for (m = 0; m < 2; ++m) {
                        diffsVec[l + 2 * m] = yValues[i + l][j + m];
                    }
                }
                for (l = 0; l < 2; ++l) {
                    for (m = 0; m < 2; ++m) {
                        diffsVec[4 + l + 2 * m] = diff0[j + m][i + l];
                    }
                }
                for (l = 0; l < 2; ++l) {
                    for (m = 0; m < 2; ++m) {
                        diffsVec[8 + l + 2 * m] = diff1[i + l][j + m];
                    }
                }
                for (l = 0; l < 2; ++l) {
                    for (m = 0; m < 2; ++m) {
                        diffsVec[12 + l + 2 * m] = cross[i + l][j + m];
                    }
                }
                DoubleArray diffs = DoubleArray.copyOf((double[])diffsVec);
                DoubleArray ansVec = (DoubleArray)MatrixAlgebraFactory.OG_ALGEBRA.multiply((Matrix)INV_MAT, (Matrix)diffs);
                double ref = 0.0;
                double[][] coefMatTmp = new double[4][4];
                for (int l2 = 0; l2 < 4; ++l2) {
                    for (int m2 = 0; m2 < 4; ++m2) {
                        coefMatTmp[4 - l2 - 1][4 - m2 - 1] = ansVec.get(l2 + m2 * 4) / Math.pow(x0Values[i + 1] - x0Values[i], l2) / Math.pow(x1Values[j + 1] - x1Values[j], m2);
                        ArgChecker.isFalse((boolean)Double.isNaN(coefMatTmp[4 - l2 - 1][4 - m2 - 1]), (String)"Too large/small input");
                        ArgChecker.isFalse((boolean)Double.isInfinite(coefMatTmp[4 - l2 - 1][4 - m2 - 1]), (String)"Too large/small input");
                        ref += coefMatTmp[4 - l2 - 1][4 - m2 - 1] * Math.pow(x0Values[i + 1] - x0Values[i], l2) * Math.pow(x1Values[j + 1] - x1Values[j], m2);
                    }
                }
                double bound = Math.max(Math.abs(ref) + Math.abs(yValues[i + 1][j + 1]), 0.1);
                ArgChecker.isTrue((Math.abs(ref - yValues[i + 1][j + 1]) < 1.0E-13 * bound ? 1 : 0) != 0, (String)"Input is too large/small or data points are too close");
                coefMat[i][j] = DoubleMatrix.copyOf((double[][])coefMatTmp);
            }
        }
        return new PiecewisePolynomialResult2D(DoubleArray.copyOf((double[])x0Values), DoubleArray.copyOf((double[])x1Values), coefMat, new int[]{4, 4});
    }

    static {
        double[][] invMat = new double[16][16];
        invMat[0] = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        invMat[1] = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        invMat[2] = new double[]{-3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        invMat[3] = new double[]{2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        invMat[4] = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        invMat[5] = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0};
        invMat[6] = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0};
        invMat[7] = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0};
        invMat[8] = new double[]{-3.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        invMat[9] = new double[]{0.0, 0.0, 0.0, 0.0, -3.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, -1.0, 0.0};
        invMat[10] = new double[]{9.0, -9.0, -9.0, 9.0, 6.0, 3.0, -6.0, -3.0, 6.0, -6.0, 3.0, -3.0, 4.0, 2.0, 2.0, 1.0};
        invMat[11] = new double[]{-6.0, 6.0, 6.0, -6.0, -3.0, -3.0, 3.0, 3.0, -4.0, 4.0, -2.0, 2.0, -2.0, -2.0, -1.0, -1.0};
        invMat[12] = new double[]{2.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        invMat[13] = new double[]{0.0, 0.0, 0.0, 0.0, 2.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0};
        invMat[14] = new double[]{-6.0, 6.0, 6.0, -6.0, -4.0, -2.0, 4.0, 2.0, -3.0, 3.0, -3.0, 3.0, -2.0, -1.0, -2.0, -1.0};
        invMat[15] = new double[]{4.0, -4.0, -4.0, 4.0, 2.0, 2.0, -2.0, -2.0, 2.0, -2.0, 2.0, -2.0, 1.0, 1.0, 1.0, 1.0};
        INV_MAT = DoubleMatrix.ofUnsafe((double[][])invMat);
    }
}

