/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.google.common.primitives.Doubles;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.DoubleArrayMath;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.interpolation.HermiteCoefficientsProvider;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialInterpolator;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResultsWithSensitivity;
import java.util.Arrays;
import java.util.stream.IntStream;

public class ConstrainedCubicSplineInterpolator
extends PiecewisePolynomialInterpolator {
    private static final double ERROR = 1.0E-13;
    private final HermiteCoefficientsProvider _solver = new HermiteCoefficientsProvider();

    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[] yValues) {
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValues, (String)"yValues");
        ArgChecker.isTrue((xValues.length == yValues.length ? 1 : 0) != 0, (String)"(xValues length = yValues length) should be true");
        ArgChecker.isTrue((xValues.length > 1 ? 1 : 0) != 0, (String)"Data points should be >= 2");
        int nDataPts = xValues.length;
        for (int i = 0; i < nDataPts; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i]), (String)"xValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i]), (String)"xValues containing Infinity");
            ArgChecker.isFalse((boolean)Double.isNaN(yValues[i]), (String)"yValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(yValues[i]), (String)"yValues containing Infinity");
        }
        double[] xValuesSrt = Arrays.copyOf(xValues, nDataPts);
        double[] yValuesSrt = Arrays.copyOf(yValues, nDataPts);
        DoubleArrayMath.sortPairs((double[])xValuesSrt, (double[])yValuesSrt);
        ArgChecker.noDuplicatesSorted((double[])xValuesSrt, (String)"xValues");
        double[] intervals = this._solver.intervalsCalculator(xValuesSrt);
        double[] slopes = this._solver.slopesCalculator(yValuesSrt, intervals);
        double[] first = this.firstDerivativeCalculator(slopes);
        double[][] coefs = this._solver.solve(yValuesSrt, intervals, slopes, first);
        for (int i = 0; i < nDataPts - 1; ++i) {
            double ref = 0.0;
            for (int j = 0; j < 4; ++j) {
                ref += coefs[i][j] * Math.pow(intervals[i], 3 - j);
                ArgChecker.isFalse((boolean)Double.isNaN(coefs[i][j]), (String)"Too large input");
                ArgChecker.isFalse((boolean)Double.isInfinite(coefs[i][j]), (String)"Too large input");
            }
            double bound = Math.max(Math.abs(ref) + Math.abs(yValuesSrt[i + 1]), 0.1);
            ArgChecker.isTrue((Math.abs(ref - yValuesSrt[i + 1]) < 1.0E-13 * bound ? 1 : 0) != 0, (String)"Input is too large/small or data points are too close");
        }
        return new PiecewisePolynomialResult(DoubleArray.copyOf((double[])xValuesSrt), DoubleMatrix.copyOf((double[][])coefs), 4, 1);
    }

    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[][] yValuesMatrix) {
        int i;
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValuesMatrix, (String)"yValuesMatrix");
        ArgChecker.isTrue((xValues.length == yValuesMatrix[0].length ? 1 : 0) != 0, (String)"(xValues length = yValuesMatrix's row vector length) should be true");
        ArgChecker.isTrue((xValues.length > 1 ? 1 : 0) != 0, (String)"Data points should be >= 2");
        int nDataPts = xValues.length;
        int yValuesLen = yValuesMatrix[0].length;
        int dim = yValuesMatrix.length;
        for (i = 0; i < nDataPts; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i]), (String)"xValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i]), (String)"xValues containing Infinity");
        }
        for (i = 0; i < yValuesLen; ++i) {
            for (int j = 0; j < dim; ++j) {
                ArgChecker.isFalse((boolean)Double.isNaN(yValuesMatrix[j][i]), (String)"yValuesMatrix containing NaN");
                ArgChecker.isFalse((boolean)Double.isInfinite(yValuesMatrix[j][i]), (String)"yValuesMatrix containing Infinity");
            }
        }
        DoubleMatrix[] coefMatrix = new DoubleMatrix[dim];
        double[] xValuesSrt = Arrays.copyOf(xValues, nDataPts);
        int[] sortedPositions = IntStream.range(0, nDataPts).toArray();
        DoubleArrayMath.sortPairs((double[])xValuesSrt, (int[])sortedPositions);
        ArgChecker.noDuplicatesSorted((double[])xValuesSrt, (String)"xValues");
        for (int i2 = 0; i2 < dim; ++i2) {
            double[] yValuesSrt = DoubleArrayMath.reorderedCopy((double[])yValuesMatrix[i2], (int[])sortedPositions);
            double[] intervals = this._solver.intervalsCalculator(xValuesSrt);
            double[] slopes = this._solver.slopesCalculator(yValuesSrt, intervals);
            double[] first = this.firstDerivativeCalculator(slopes);
            coefMatrix[i2] = DoubleMatrix.copyOf((double[][])this._solver.solve(yValuesSrt, intervals, slopes, first));
            for (int k = 0; k < intervals.length; ++k) {
                double ref = 0.0;
                for (int j = 0; j < 4; ++j) {
                    ref += coefMatrix[i2].get(k, j) * Math.pow(intervals[k], 3 - j);
                    ArgChecker.isFalse((boolean)Double.isNaN(coefMatrix[i2].get(k, j)), (String)"Too large input");
                    ArgChecker.isFalse((boolean)Double.isInfinite(coefMatrix[i2].get(k, j)), (String)"Too large input");
                }
                double bound = Math.max(Math.abs(ref) + Math.abs(yValuesSrt[k + 1]), 0.1);
                ArgChecker.isTrue((Math.abs(ref - yValuesSrt[k + 1]) < 1.0E-13 * bound ? 1 : 0) != 0, (String)"Input is too large/small or data points are too close");
            }
        }
        int nIntervals = coefMatrix[0].rowCount();
        int nCoefs = coefMatrix[0].columnCount();
        double[][] resMatrix = new double[dim * nIntervals][nCoefs];
        for (int i3 = 0; i3 < nIntervals; ++i3) {
            for (int j = 0; j < dim; ++j) {
                resMatrix[dim * i3 + j] = coefMatrix[j].row(i3).toArray();
            }
        }
        return new PiecewisePolynomialResult(DoubleArray.copyOf((double[])xValuesSrt), DoubleMatrix.copyOf((double[][])resMatrix), nCoefs, dim);
    }

    @Override
    public PiecewisePolynomialResultsWithSensitivity interpolateWithSensitivity(double[] xValues, double[] yValues) {
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValues, (String)"yValues");
        ArgChecker.isTrue((xValues.length == yValues.length ? 1 : 0) != 0, (String)"(xValues length = yValues length) should be true");
        ArgChecker.isTrue((xValues.length > 1 ? 1 : 0) != 0, (String)"Data points should be >= 2");
        int nDataPts = xValues.length;
        for (int i = 0; i < nDataPts; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i]), (String)"xValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i]), (String)"xValues containing Infinity");
            ArgChecker.isFalse((boolean)Double.isNaN(yValues[i]), (String)"yValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(yValues[i]), (String)"yValues containing Infinity");
        }
        ArgChecker.noDuplicates((double[])xValues, (String)"xValues");
        double[] intervals = this._solver.intervalsCalculator(xValues);
        double[] slopes = this._solver.slopesCalculator(yValues, intervals);
        double[][] slopeSensitivity = this._solver.slopeSensitivityCalculator(intervals);
        DoubleArray[] firstWithSensitivity = this.firstDerivativeWithSensitivityCalculator(slopes, slopeSensitivity);
        DoubleMatrix[] resMatrix = this._solver.solveWithSensitivity(yValues, intervals, slopes, slopeSensitivity, firstWithSensitivity);
        for (int k = 0; k < nDataPts; ++k) {
            DoubleMatrix m = resMatrix[k];
            int rows = m.rowCount();
            int cols = m.columnCount();
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    ArgChecker.isTrue((boolean)Doubles.isFinite((double)m.get(i, j)), (String)"Matrix contains a NaN or infinite");
                }
            }
        }
        DoubleMatrix coefMatrix = resMatrix[0];
        for (int i = 0; i < nDataPts - 1; ++i) {
            double ref = 0.0;
            for (int j = 0; j < 4; ++j) {
                ref += coefMatrix.get(i, j) * Math.pow(intervals[i], 3 - j);
            }
            double bound = Math.max(Math.abs(ref) + Math.abs(yValues[i + 1]), 0.1);
            ArgChecker.isTrue((Math.abs(ref - yValues[i + 1]) < 1.0E-13 * bound ? 1 : 0) != 0, (String)"Input is too large/small or data points are too close");
        }
        DoubleMatrix[] coefSenseMatrix = new DoubleMatrix[nDataPts - 1];
        System.arraycopy(resMatrix, 1, coefSenseMatrix, 0, nDataPts - 1);
        int nCoefs = coefMatrix.columnCount();
        return new PiecewisePolynomialResultsWithSensitivity(DoubleArray.copyOf((double[])xValues), coefMatrix, nCoefs, 1, coefSenseMatrix);
    }

    private double[] firstDerivativeCalculator(double[] slopes) {
        int nData = slopes.length + 1;
        double[] res = new double[nData];
        for (int i = 1; i < nData - 1; ++i) {
            res[i] = Math.signum(slopes[i - 1]) * Math.signum(slopes[i]) <= 0.0 ? 0.0 : 2.0 * slopes[i] * slopes[i - 1] / (slopes[i] + slopes[i - 1]);
        }
        res[0] = 1.5 * slopes[0] - 0.5 * res[1];
        res[nData - 1] = 1.5 * slopes[nData - 2] - 0.5 * res[nData - 2];
        return res;
    }

    private DoubleArray[] firstDerivativeWithSensitivityCalculator(double[] slopes, double[][] slopeSensitivity) {
        int nData = slopes.length + 1;
        double[] first = new double[nData];
        double[][] sense = new double[nData][nData];
        DoubleArray[] res = new DoubleArray[nData + 1];
        for (int i = 1; i < nData - 1; ++i) {
            double sign = Math.signum(slopes[i - 1]) * Math.signum(slopes[i]);
            first[i] = sign <= 0.0 ? 0.0 : 2.0 * slopes[i] * slopes[i - 1] / (slopes[i] + slopes[i - 1]);
            if (sign < 0.0) {
                Arrays.fill(sense[i], 0.0);
            } else {
                for (int k = 0; k < nData; ++k) {
                    if (Math.abs(slopes[i] + slopes[i - 1]) == 0.0) {
                        Arrays.fill(sense[i], 0.0);
                        continue;
                    }
                    sense[i][k] = sign == 0.0 ? (slopes[i] * slopes[i] * slopeSensitivity[i - 1][k] + slopes[i - 1] * slopes[i - 1] * slopeSensitivity[i][k]) / (slopes[i] + slopes[i - 1]) / (slopes[i] + slopes[i - 1]) : 2.0 * (slopes[i] * slopes[i] * slopeSensitivity[i - 1][k] + slopes[i - 1] * slopes[i - 1] * slopeSensitivity[i][k]) / (slopes[i] + slopes[i - 1]) / (slopes[i] + slopes[i - 1]);
                }
            }
            res[i + 1] = DoubleArray.copyOf((double[])sense[i]);
        }
        first[0] = 1.5 * slopes[0] - 0.5 * first[1];
        first[nData - 1] = 1.5 * slopes[nData - 2] - 0.5 * first[nData - 2];
        res[0] = DoubleArray.copyOf((double[])first);
        for (int k = 0; k < nData; ++k) {
            sense[0][k] = 1.5 * slopeSensitivity[0][k] - 0.5 * sense[1][k];
            sense[nData - 1][k] = 1.5 * slopeSensitivity[nData - 2][k] - 0.5 * sense[nData - 2][k];
        }
        res[1] = DoubleArray.copyOf((double[])sense[0]);
        res[nData] = DoubleArray.copyOf((double[])sense[nData - 1]);
        return res;
    }
}

