/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.interpolation.CubicSplineSolver;
import java.util.Arrays;

public class CubicSplineNakSolver
extends CubicSplineSolver {
    @Override
    public DoubleMatrix solve(double[] xValues, double[] yValues) {
        double[] intervals = this.getDiffs(xValues);
        return this.getSplineCoeffs(xValues, yValues, intervals, this.matrixEqnSolver(this.getMatrix(intervals), this.getVector(yValues, intervals)));
    }

    @Override
    public DoubleMatrix[] solveWithSensitivity(double[] xValues, double[] yValues) {
        double[] intervals = this.getDiffs(xValues);
        double[][] toBeInv = this.getMatrix(intervals);
        double[] vector = this.getVector(yValues, intervals);
        double[][] vecSensitivity = this.getVectorSensitivity(intervals);
        return this.getSplineCoeffsWithSensitivity(xValues, yValues, intervals, toBeInv, vector, vecSensitivity);
    }

    @Override
    public DoubleMatrix[] solveMultiDim(double[] xValues, DoubleMatrix yValuesMatrix) {
        int dim = yValuesMatrix.rowCount();
        DoubleMatrix[] coefMatrix = new DoubleMatrix[dim];
        for (int i = 0; i < dim; ++i) {
            coefMatrix[i] = this.solve(xValues, yValuesMatrix.row(i).toArray());
        }
        return coefMatrix;
    }

    @Override
    public DoubleArray getKnotsMat1D(double[] xValues) {
        int nData = xValues.length;
        if (nData == 2) {
            return DoubleArray.of((double)xValues[0], (double)xValues[nData - 1]);
        }
        if (nData == 3) {
            return DoubleArray.of((double)xValues[0], (double)xValues[nData - 1]);
        }
        return DoubleArray.copyOf((double[])xValues);
    }

    private DoubleMatrix getSplineCoeffs(double[] xValues, double[] yValues, double[] intervals, double[] solnVector) {
        int nData = xValues.length;
        if (nData == 2) {
            double[][] res = new double[][]{{yValues[1] / intervals[0] - yValues[0] / intervals[0] - intervals[0] * solnVector[0] / 2.0 - intervals[0] * solnVector[1] / 6.0 + intervals[0] * solnVector[0] / 6.0, yValues[0]}};
            return DoubleMatrix.copyOf((double[][])res);
        }
        if (nData == 3) {
            double[][] res = new double[][]{{solnVector[0] / 2.0, yValues[1] / intervals[0] - yValues[0] / intervals[0] - intervals[0] * solnVector[0] / 2.0, yValues[0]}};
            return DoubleMatrix.copyOf((double[][])res);
        }
        return this.getCommonSplineCoeffs(xValues, yValues, intervals, solnVector);
    }

    private DoubleMatrix[] getSplineCoeffsWithSensitivity(double[] xValues, double[] yValues, double[] intervals, double[][] toBeInv, double[] vector, double[][] vecSensitivity) {
        int nData = xValues.length;
        if (nData == 2) {
            DoubleMatrix[] res = new DoubleMatrix[nData];
            res[0] = DoubleMatrix.of((int)1, (int)1, (double[])new double[]{yValues[1] / intervals[0] - yValues[0] / intervals[0], yValues[0]});
            res[1] = DoubleMatrix.of((int)2, (int)2, (double[])new double[]{-1.0 / intervals[0], 1.0 / intervals[0], 1.0, 0.0});
            return res;
        }
        if (nData == 3) {
            DoubleMatrix[] res = new DoubleMatrix[2];
            DoubleArray[] soln = this.combinedMatrixEqnSolver(toBeInv, vector, vecSensitivity);
            double[][] coef = new double[][]{{soln[0].get(0) / 2.0, yValues[1] / intervals[0] - yValues[0] / intervals[0] - intervals[0] * soln[0].get(0) / 2.0, yValues[0]}};
            res[0] = DoubleMatrix.copyOf((double[][])coef);
            double[][] coefSense = new double[3][0];
            coefSense[0] = new double[]{soln[1].get(0) / 2.0, soln[2].get(0) / 2.0, soln[3].get(0) / 2.0};
            coefSense[1] = new double[]{-1.0 / intervals[0] - intervals[0] * soln[1].get(0) / 2.0, 1.0 / intervals[0] - intervals[0] * soln[2].get(0) / 2.0, -intervals[0] * soln[3].get(0) / 2.0};
            coefSense[2] = new double[]{1.0, 0.0, 0.0};
            res[1] = DoubleMatrix.copyOf((double[][])coefSense);
            return res;
        }
        DoubleMatrix[] res = new DoubleMatrix[nData];
        DoubleArray[] soln = this.combinedMatrixEqnSolver(toBeInv, vector, vecSensitivity);
        res[0] = this.getCommonSplineCoeffs(xValues, yValues, intervals, soln[0].toArray());
        double[][] solnMatrix = new double[nData][nData];
        for (int i = 0; i < nData; ++i) {
            for (int j = 0; j < nData; ++j) {
                solnMatrix[i][j] = soln[j + 1].get(i);
            }
        }
        DoubleMatrix[] tmp = this.getCommonSensitivityCoeffs(intervals, solnMatrix);
        System.arraycopy(tmp, 0, res, 1, nData - 1);
        return res;
    }

    private double[] getVector(double[] yValues, double[] intervals) {
        int nData = yValues.length;
        double[] res = new double[nData];
        if (nData == 3) {
            for (int i = 0; i < nData; ++i) {
                res[i] = 2.0 * yValues[2] / (intervals[0] + intervals[1]) - 2.0 * yValues[0] / (intervals[0] + intervals[1]) - 2.0 * yValues[1] / intervals[0] + 2.0 * yValues[0] / intervals[0];
            }
        } else {
            res = this.getCommonVectorElements(yValues, intervals);
        }
        return res;
    }

    private double[][] getVectorSensitivity(double[] intervals) {
        int nData = intervals.length + 1;
        double[][] res = new double[nData][nData];
        if (nData == 3) {
            for (int i = 0; i < nData; ++i) {
                res[i][0] = -2.0 / (intervals[0] + intervals[1]) + 2.0 / intervals[0];
                res[i][1] = -2.0 / intervals[0];
                res[i][2] = 2.0 / (intervals[0] + intervals[1]);
            }
        } else {
            res = this.getCommonVectorSensitivity(intervals);
        }
        return res;
    }

    private double[][] getMatrix(double[] intervals) {
        int nData = intervals.length + 1;
        double[][] res = new double[nData][nData];
        for (int i = 0; i < nData; ++i) {
            Arrays.fill(res[i], 0.0);
        }
        if (nData == 2) {
            res[0][1] = intervals[0];
            res[1][0] = intervals[0];
            return res;
        }
        if (nData == 3) {
            res[0][0] = intervals[1];
            res[1][1] = intervals[1];
            res[2][2] = intervals[1];
            return res;
        }
        res = this.getCommonMatrixElements(intervals);
        res[0][0] = -intervals[1];
        res[0][1] = intervals[0] + intervals[1];
        res[0][2] = -intervals[0];
        res[nData - 1][nData - 3] = -intervals[nData - 2];
        res[nData - 1][nData - 2] = intervals[nData - 3] + intervals[nData - 2];
        res[nData - 1][nData - 1] = -intervals[nData - 3];
        return res;
    }
}

