/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.interpolation.CubicSplineSolver;

public class CubicSplineNaturalSolver
extends CubicSplineSolver {
    @Override
    public DoubleMatrix solve(double[] xValues, double[] yValues) {
        double[] intervals = this.getDiffs(xValues);
        return this.getCommonSplineCoeffs(xValues, yValues, intervals, this.matrixEqnSolver(this.getMatrix(intervals), this.getCommonVectorElements(yValues, intervals)));
    }

    @Override
    public DoubleMatrix[] solveWithSensitivity(double[] xValues, double[] yValues) {
        double[] intervals = this.getDiffs(xValues);
        double[][] toBeInv = this.getMatrix(intervals);
        double[] commonVector = this.getCommonVectorElements(yValues, intervals);
        double[][] commonVecSensitivity = this.getCommonVectorSensitivity(intervals);
        return this.getCommonCoefficientWithSensitivity(xValues, yValues, intervals, toBeInv, commonVector, commonVecSensitivity);
    }

    @Override
    public DoubleMatrix[] solveMultiDim(double[] xValues, DoubleMatrix yValuesMatrix) {
        int dim = yValuesMatrix.rowCount();
        DoubleMatrix[] coefMatrix = new DoubleMatrix[dim];
        for (int i = 0; i < dim; ++i) {
            coefMatrix[i] = this.solve(xValues, yValuesMatrix.row(i).toArray());
        }
        return coefMatrix;
    }

    private double[][] getMatrix(double[] intervals) {
        int nData = intervals.length + 1;
        double[][] res = new double[nData][nData];
        res = this.getCommonMatrixElements(intervals);
        res[0][0] = 1.0;
        res[nData - 1][nData - 1] = 1.0;
        return res;
    }
}

