/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import java.util.Arrays;

public class HermiteCoefficientsProvider {
    public double[][] solve(double[] values, double[] intervals, double[] slopes, double[] first) {
        int i;
        int nInt = intervals.length;
        double[][] res = new double[nInt][4];
        for (i = 0; i < nInt; ++i) {
            Arrays.fill(res[i], 0.0);
        }
        for (i = 0; i < nInt; ++i) {
            res[i][3] = values[i];
            res[i][2] = first[i];
            res[i][1] = (3.0 * slopes[i] - first[i + 1] - 2.0 * first[i]) / intervals[i];
            res[i][0] = -(2.0 * slopes[i] - first[i + 1] - first[i]) / intervals[i] / intervals[i];
        }
        return res;
    }

    public DoubleMatrix[] solveWithSensitivity(double[] values, double[] intervals, double[] slopes, double[][] slopeSensitivity, DoubleArray[] firstWithSensitivity) {
        int nData = values.length;
        double[] first = firstWithSensitivity[0].toArray();
        DoubleMatrix[] res = new DoubleMatrix[nData];
        double[][] coef = this.solve(values, intervals, slopes, first);
        res[0] = DoubleMatrix.copyOf((double[][])coef);
        for (int i = 0; i < nData - 1; ++i) {
            double[][] coefSense = new double[4][nData];
            Arrays.fill(coefSense[3], 0.0);
            coefSense[3][i] = 1.0;
            for (int k = 0; k < nData; ++k) {
                coefSense[0][k] = -(2.0 * slopeSensitivity[i][k] - firstWithSensitivity[i + 2].get(k) - firstWithSensitivity[i + 1].get(k)) / intervals[i] / intervals[i];
                coefSense[1][k] = (3.0 * slopeSensitivity[i][k] - firstWithSensitivity[i + 2].get(k) - 2.0 * firstWithSensitivity[i + 1].get(k)) / intervals[i];
                coefSense[2][k] = firstWithSensitivity[i + 1].get(k);
            }
            res[i + 1] = DoubleMatrix.copyOf((double[][])coefSense);
        }
        return res;
    }

    public double[][] solve(double[] values, double[] intervals, double[] slopes, double[] first, double[] second) {
        int i;
        int nInt = intervals.length;
        double[][] res = new double[nInt][6];
        for (i = 0; i < nInt; ++i) {
            Arrays.fill(res[i], 0.0);
        }
        for (i = 0; i < nInt; ++i) {
            res[i][5] = values[i];
            res[i][4] = first[i];
            res[i][3] = 0.5 * second[i];
            res[i][2] = 0.5 * (second[i + 1] - 3.0 * second[i]) / intervals[i] + 2.0 * (5.0 * slopes[i] - 3.0 * first[i] - 2.0 * first[i + 1]) / intervals[i] / intervals[i];
            res[i][1] = 0.5 * (3.0 * second[i] - 2.0 * second[i + 1]) / intervals[i] / intervals[i] + (8.0 * first[i] + 7.0 * first[i + 1] - 15.0 * slopes[i]) / intervals[i] / intervals[i] / intervals[i];
            res[i][0] = 0.5 * (second[i + 1] - second[i]) / intervals[i] / intervals[i] / intervals[i] + 3.0 * (2.0 * slopes[i] - first[i + 1] - first[i]) / intervals[i] / intervals[i] / intervals[i] / intervals[i];
        }
        return res;
    }

    public DoubleMatrix[] solveWithSensitivity(double[] values, double[] intervals, double[] slopes, double[][] slopeSensitivity, DoubleArray[] firstWithSensitivity, DoubleArray[] secondWithSensitivity) {
        int nData = values.length;
        double[] first = firstWithSensitivity[0].toArray();
        double[] second = secondWithSensitivity[0].toArray();
        DoubleMatrix[] res = new DoubleMatrix[nData];
        double[][] coef = this.solve(values, intervals, slopes, first, second);
        res[0] = DoubleMatrix.copyOf((double[][])coef);
        for (int i = 0; i < nData - 1; ++i) {
            double interval = intervals[i];
            double[][] coefSense = new double[6][nData];
            Arrays.fill(coefSense[5], 0.0);
            coefSense[5][i] = 1.0;
            for (int k = 0; k < nData; ++k) {
                double cs0b = 2.0 * slopeSensitivity[i][k] - firstWithSensitivity[i + 2].get(k) - firstWithSensitivity[i + 1].get(k);
                double cs0a = secondWithSensitivity[i + 2].get(k) - secondWithSensitivity[i + 1].get(k);
                coefSense[0][k] = 0.5 * cs0a / interval / interval / interval + 3.0 * cs0b / interval / interval / interval / interval;
                double cs1a = 3.0 * secondWithSensitivity[i + 1].get(k) - 2.0 * secondWithSensitivity[i + 2].get(k);
                double cs1b = 8.0 * firstWithSensitivity[i + 1].get(k) + 7.0 * firstWithSensitivity[i + 2].get(k) - 15.0 * slopeSensitivity[i][k];
                coefSense[1][k] = 0.5 * cs1a / interval / interval + cs1b / interval / interval / interval;
                double cs2a = secondWithSensitivity[i + 2].get(k) - 3.0 * secondWithSensitivity[i + 1].get(k);
                double cs2b = 5.0 * slopeSensitivity[i][k] - 3.0 * firstWithSensitivity[i + 1].get(k) - 2.0 * firstWithSensitivity[i + 2].get(k);
                coefSense[2][k] = 0.5 * cs2a / interval + 2.0 * cs2b / interval / interval;
                coefSense[3][k] = 0.5 * secondWithSensitivity[i + 1].get(k);
                coefSense[4][k] = firstWithSensitivity[i + 1].get(k);
            }
            res[i + 1] = DoubleMatrix.copyOf((double[][])coefSense);
        }
        return res;
    }

    public double[] intervalsCalculator(double[] xValues) {
        int nDataPts = xValues.length;
        double[] intervals = new double[nDataPts - 1];
        for (int i = 0; i < nDataPts - 1; ++i) {
            intervals[i] = xValues[i + 1] - xValues[i];
        }
        return intervals;
    }

    public double[] slopesCalculator(double[] yValues, double[] intervals) {
        int nDataPts = yValues.length;
        double[] slopes = new double[nDataPts - 1];
        for (int i = 0; i < nDataPts - 1; ++i) {
            slopes[i] = (yValues[i + 1] - yValues[i]) / intervals[i];
        }
        return slopes;
    }

    public double[][] slopeSensitivityCalculator(double[] intervals) {
        int nDataPts = intervals.length + 1;
        double[][] res = new double[nDataPts - 1][nDataPts];
        for (int i = 0; i < nDataPts - 1; ++i) {
            Arrays.fill(res[i], 0.0);
            res[i][i] = -1.0 / intervals[i];
            res[i][i + 1] = 1.0 / intervals[i];
        }
        return res;
    }

    public double endpointDerivatives(double ints1, double ints2, double slope1, double slope2) {
        double val = (2.0 * ints1 + ints2) * slope1 / (ints1 + ints2) - ints1 * slope2 / (ints1 + ints2);
        if (Math.signum(val) != Math.signum(slope1)) {
            return 0.0;
        }
        if (Math.signum(slope1) != Math.signum(slope2) && Math.abs(val) > 3.0 * Math.abs(slope1)) {
            return 3.0 * slope1;
        }
        return val;
    }
}

