/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.google.common.primitives.Doubles;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.DoubleArrayMath;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.function.PiecewisePolynomialWithSensitivityFunction1D;
import com.opengamma.strata.math.impl.interpolation.HermiteCoefficientsProvider;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialInterpolator;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResultsWithSensitivity;
import java.util.Arrays;
import java.util.stream.IntStream;

public class MonotonicityPreservingCubicSplineInterpolator
extends PiecewisePolynomialInterpolator {
    private final HermiteCoefficientsProvider _solver = new HermiteCoefficientsProvider();
    private final PiecewisePolynomialWithSensitivityFunction1D _function = new PiecewisePolynomialWithSensitivityFunction1D();
    private PiecewisePolynomialInterpolator _method;
    private static final double EPS = 1.0E-7;
    private static final double SMALL = 1.0E-14;

    public MonotonicityPreservingCubicSplineInterpolator(PiecewisePolynomialInterpolator method) {
        this._method = method;
    }

    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[] yValues) {
        int i;
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValues, (String)"yValues");
        ArgChecker.isTrue((boolean)(xValues.length == yValues.length | xValues.length + 2 == yValues.length), (String)"(xValues length = yValues length) or (xValues length + 2 = yValues length)");
        ArgChecker.isTrue((xValues.length > 4 ? 1 : 0) != 0, (String)"Data points should be more than 4");
        int nDataPts = xValues.length;
        int yValuesLen = yValues.length;
        for (i = 0; i < nDataPts; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i]), (String)"xValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i]), (String)"xValues containing Infinity");
        }
        for (i = 0; i < yValuesLen; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(yValues[i]), (String)"yValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(yValues[i]), (String)"yValues containing Infinity");
        }
        double[] xValuesSrt = Arrays.copyOf(xValues, nDataPts);
        double[] yValuesSrt = nDataPts == yValuesLen ? Arrays.copyOf(yValues, nDataPts) : Arrays.copyOfRange(yValues, 1, nDataPts + 1);
        DoubleArrayMath.sortPairs((double[])xValuesSrt, (double[])yValuesSrt);
        ArgChecker.noDuplicatesSorted((double[])xValuesSrt, (String)"xValues");
        double[] intervals = this._solver.intervalsCalculator(xValuesSrt);
        double[] slopes = this._solver.slopesCalculator(yValuesSrt, intervals);
        PiecewisePolynomialResult result = this._method.interpolate(xValues, yValues);
        ArgChecker.isTrue((result.getOrder() == 4 ? 1 : 0) != 0, (String)"Primary interpolant is not cubic");
        double[] initialFirst = this._function.differentiate(result, xValuesSrt).rowArray(0);
        double[] first = this.firstDerivativeCalculator(intervals, slopes, initialFirst);
        double[][] coefs = this._solver.solve(yValuesSrt, intervals, slopes, first);
        for (int i2 = 0; i2 < nDataPts - 1; ++i2) {
            for (int j = 0; j < 4; ++j) {
                ArgChecker.isFalse((boolean)Double.isNaN(coefs[i2][j]), (String)"Too large input");
                ArgChecker.isFalse((boolean)Double.isInfinite(coefs[i2][j]), (String)"Too large input");
            }
        }
        return new PiecewisePolynomialResult(DoubleArray.copyOf((double[])xValuesSrt), DoubleMatrix.copyOf((double[][])coefs), 4, 1);
    }

    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[][] yValuesMatrix) {
        int i;
        int i2;
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValuesMatrix, (String)"yValuesMatrix");
        ArgChecker.isTrue((boolean)(xValues.length == yValuesMatrix[0].length | xValues.length + 2 == yValuesMatrix[0].length), (String)"(xValues length = yValuesMatrix's row vector length) or (xValues length + 2 = yValuesMatrix's row vector length)");
        ArgChecker.isTrue((xValues.length > 4 ? 1 : 0) != 0, (String)"Data points should be more than 4");
        int nDataPts = xValues.length;
        int yValuesLen = yValuesMatrix[0].length;
        int dim = yValuesMatrix.length;
        for (i2 = 0; i2 < nDataPts; ++i2) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i2]), (String)"xValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i2]), (String)"xValues containing Infinity");
        }
        for (i2 = 0; i2 < yValuesLen; ++i2) {
            for (int j = 0; j < dim; ++j) {
                ArgChecker.isFalse((boolean)Double.isNaN(yValuesMatrix[j][i2]), (String)"yValuesMatrix containing NaN");
                ArgChecker.isFalse((boolean)Double.isInfinite(yValuesMatrix[j][i2]), (String)"yValuesMatrix containing Infinity");
            }
        }
        double[] xValuesSrt = Arrays.copyOf(xValues, nDataPts);
        int[] sortedPositions = IntStream.range(0, nDataPts).toArray();
        DoubleArrayMath.sortPairs((double[])xValuesSrt, (int[])sortedPositions);
        ArgChecker.noDuplicatesSorted((double[])xValuesSrt, (String)"xValues");
        DoubleMatrix[] coefMatrix = new DoubleMatrix[dim];
        for (int i3 = 0; i3 < dim; ++i3) {
            double[] yValuesSrt;
            if (nDataPts == yValuesLen) {
                yValuesSrt = DoubleArrayMath.reorderedCopy((double[])yValuesMatrix[i3], (int[])sortedPositions);
            } else {
                double[] copy = Arrays.copyOfRange(yValuesMatrix[i3], 1, nDataPts + 1);
                yValuesSrt = DoubleArrayMath.reorderedCopy((double[])copy, (int[])sortedPositions);
            }
            double[] intervals = this._solver.intervalsCalculator(xValuesSrt);
            double[] slopes = this._solver.slopesCalculator(yValuesSrt, intervals);
            PiecewisePolynomialResult result = this._method.interpolate(xValues, yValuesMatrix[i3]);
            ArgChecker.isTrue((result.getOrder() == 4 ? 1 : 0) != 0, (String)"Primary interpolant is not cubic");
            double[] initialFirst = this._function.differentiate(result, xValuesSrt).rowArray(0);
            double[] first = this.firstDerivativeCalculator(intervals, slopes, initialFirst);
            coefMatrix[i3] = DoubleMatrix.copyOf((double[][])this._solver.solve(yValuesSrt, intervals, slopes, first));
        }
        int nIntervals = coefMatrix[0].rowCount();
        int nCoefs = coefMatrix[0].columnCount();
        double[][] resMatrix = new double[dim * nIntervals][nCoefs];
        for (i = 0; i < nIntervals; ++i) {
            for (int j = 0; j < dim; ++j) {
                resMatrix[dim * i + j] = coefMatrix[j].row(i).toArray();
            }
        }
        for (i = 0; i < nIntervals * dim; ++i) {
            for (int j = 0; j < nCoefs; ++j) {
                ArgChecker.isFalse((boolean)Double.isNaN(resMatrix[i][j]), (String)"Too large input");
                ArgChecker.isFalse((boolean)Double.isInfinite(resMatrix[i][j]), (String)"Too large input");
            }
        }
        return new PiecewisePolynomialResult(DoubleArray.copyOf((double[])xValuesSrt), DoubleMatrix.copyOf((double[][])resMatrix), nCoefs, dim);
    }

    @Override
    public PiecewisePolynomialResultsWithSensitivity interpolateWithSensitivity(double[] xValues, double[] yValues) {
        double[] initialFirst;
        int i;
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValues, (String)"yValues");
        ArgChecker.isTrue((boolean)(xValues.length == yValues.length | xValues.length + 2 == yValues.length), (String)"(xValues length = yValues length) or (xValues length + 2 = yValues length)");
        ArgChecker.isTrue((xValues.length > 4 ? 1 : 0) != 0, (String)"Data points should be more than 4");
        int nDataPts = xValues.length;
        int yValuesLen = yValues.length;
        for (i = 0; i < nDataPts; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i]), (String)"xValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i]), (String)"xValues containing Infinity");
        }
        for (i = 0; i < yValuesLen; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(yValues[i]), (String)"yValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(yValues[i]), (String)"yValues containing Infinity");
        }
        double[] yValuesSrt = nDataPts == yValuesLen ? Arrays.copyOf(yValues, nDataPts) : Arrays.copyOfRange(yValues, 1, nDataPts + 1);
        ArgChecker.noDuplicatesSorted((double[])xValues, (String)"xValues");
        double[] intervals = this._solver.intervalsCalculator(xValues);
        double[] slopes = this._solver.slopesCalculator(yValuesSrt, intervals);
        DoubleMatrix[] slopesSensitivityWithAbs = this.slopesSensitivityWithAbsCalculator(intervals, slopes);
        double[][] slopesSensitivity = slopesSensitivityWithAbs[0].toArray();
        double[][] slopesAbsSensitivity = slopesSensitivityWithAbs[1].toArray();
        DoubleArray[] firstWithSensitivity = new DoubleArray[nDataPts + 1];
        boolean sym = this.checkSymm(slopes);
        if (sym) {
            int i2;
            PiecewisePolynomialResult result = this._method.interpolate(xValues, yValues);
            ArgChecker.isTrue((result.getOrder() == 4 ? 1 : 0) != 0, (String)"Primary interpolant is not cubic");
            initialFirst = this._function.differentiate(result, xValues).rowArray(0);
            firstWithSensitivity[0] = DoubleArray.copyOf((double[])this.firstDerivativeCalculator(intervals, slopes, initialFirst));
            int nExtra = nDataPts == yValuesLen ? 0 : 1;
            double[] yValuesUp = Arrays.copyOf(yValues, nDataPts + 2 * nExtra);
            double[] yValuesDw = Arrays.copyOf(yValues, nDataPts + 2 * nExtra);
            double[][] tmp = new double[nDataPts][nDataPts];
            for (i2 = nExtra; i2 < nDataPts + nExtra; ++i2) {
                double den = Math.abs(yValues[i2]) < 1.0E-14 ? 1.0E-7 : yValues[i2] * 1.0E-7;
                yValuesUp[i2] = Math.abs(yValues[i2]) < 1.0E-14 ? 1.0E-7 : yValues[i2] * 1.0000001;
                yValuesDw[i2] = Math.abs(yValues[i2]) < 1.0E-14 ? -1.0E-7 : yValues[i2] * 0.9999999;
                double[] yValuesSrtUp = Arrays.copyOfRange(yValuesUp, nExtra, nDataPts + nExtra);
                double[] yValuesSrtDw = Arrays.copyOfRange(yValuesDw, nExtra, nDataPts + nExtra);
                double[] slopesUp = this._solver.slopesCalculator(yValuesSrtUp, intervals);
                double[] slopesDw = this._solver.slopesCalculator(yValuesSrtDw, intervals);
                double[] initialFirstUp = this._function.differentiate(this._method.interpolate(xValues, yValuesUp), xValues).rowArray(0);
                double[] initialFirstDw = this._function.differentiate(this._method.interpolate(xValues, yValuesDw), xValues).rowArray(0);
                double[] firstUp = this.firstDerivativeCalculator(intervals, slopesUp, initialFirstUp);
                double[] firstDw = this.firstDerivativeCalculator(intervals, slopesDw, initialFirstDw);
                for (int j = 0; j < nDataPts; ++j) {
                    tmp[j][i2 - nExtra] = 0.5 * (firstUp[j] - firstDw[j]) / den;
                }
                yValuesUp[i2] = yValues[i2];
                yValuesDw[i2] = yValues[i2];
            }
            for (i2 = 0; i2 < nDataPts; ++i2) {
                firstWithSensitivity[i2 + 1] = DoubleArray.copyOf((double[])tmp[i2]);
            }
        } else {
            PiecewisePolynomialResultsWithSensitivity resultWithSensitivity = this._method.interpolateWithSensitivity(xValues, yValues);
            ArgChecker.isTrue((resultWithSensitivity.getOrder() == 4 ? 1 : 0) != 0, (String)"Primary interpolant is not cubic");
            initialFirst = this._function.differentiate((PiecewisePolynomialResult)resultWithSensitivity, xValues).rowArray(0);
            DoubleArray[] initialFirstSense = this._function.differentiateNodeSensitivity(resultWithSensitivity, xValues);
            firstWithSensitivity = this.firstDerivativeWithSensitivityCalculator(intervals, slopes, slopesSensitivity, slopesAbsSensitivity, initialFirst, initialFirstSense);
        }
        DoubleMatrix[] resMatrix = this._solver.solveWithSensitivity(yValuesSrt, intervals, slopes, slopesSensitivity, firstWithSensitivity);
        for (int k = 0; k < nDataPts; ++k) {
            DoubleMatrix m = resMatrix[k];
            int rows = m.rowCount();
            int cols = m.columnCount();
            for (int i3 = 0; i3 < rows; ++i3) {
                for (int j = 0; j < cols; ++j) {
                    ArgChecker.isTrue((boolean)Doubles.isFinite((double)m.get(i3, j)), (String)"Matrix contains a NaN or infinite");
                }
            }
        }
        DoubleMatrix coefMatrix = resMatrix[0];
        DoubleMatrix[] coefSenseMatrix = new DoubleMatrix[nDataPts - 1];
        System.arraycopy(resMatrix, 1, coefSenseMatrix, 0, nDataPts - 1);
        int nCoefs = coefMatrix.columnCount();
        return new PiecewisePolynomialResultsWithSensitivity(DoubleArray.copyOf((double[])xValues), coefMatrix, nCoefs, 1, coefSenseMatrix);
    }

    @Override
    public PiecewisePolynomialInterpolator getPrimaryMethod() {
        return this._method;
    }

    private double[] firstDerivativeCalculator(double[] intervals, double[] slopes, double[] initialFirst) {
        int nDataPts = intervals.length + 1;
        double[] res = new double[nDataPts];
        double[][] pSlopes = this.parabolaSlopesCalculator(intervals, slopes);
        for (int i = 1; i < nDataPts - 1; ++i) {
            double sig4;
            double sig3;
            double sig2;
            double sig1;
            double refValue = 3.0 * Math.min(Math.abs(slopes[i - 1]), Math.min(Math.abs(slopes[i]), Math.abs(pSlopes[i - 1][1])));
            if (i > 1) {
                sig1 = Math.signum(pSlopes[i - 1][1]);
                sig2 = Math.signum(pSlopes[i - 1][0]);
                sig3 = Math.signum(slopes[i - 1] - slopes[i - 2]);
                sig4 = Math.signum(slopes[i] - slopes[i - 1]);
                if (Math.abs(sig1 - sig2) <= 0.0 && Math.abs(sig2 - sig3) <= 0.0 && Math.abs(sig3 - sig4) <= 0.0) {
                    refValue = Math.max(refValue, 1.5 * Math.min(Math.abs(pSlopes[i - 1][0]), Math.abs(pSlopes[i - 1][1])));
                }
            }
            if (i < nDataPts - 2) {
                sig1 = Math.signum(-pSlopes[i - 1][1]);
                sig2 = Math.signum(-pSlopes[i - 1][2]);
                sig3 = Math.signum(slopes[i + 1] - slopes[i]);
                sig4 = Math.signum(slopes[i] - slopes[i - 1]);
                if (Math.abs(sig1 - sig2) <= 0.0 && Math.abs(sig2 - sig3) <= 0.0 && Math.abs(sig3 - sig4) <= 0.0) {
                    refValue = Math.max(refValue, 1.5 * Math.min(Math.abs(pSlopes[i - 1][2]), Math.abs(pSlopes[i - 1][1])));
                }
            }
            res[i] = Math.signum(initialFirst[i]) != Math.signum(pSlopes[i - 1][1]) ? 0.0 : Math.signum(initialFirst[i]) * Math.min(Math.abs(initialFirst[i]), refValue);
        }
        res[0] = Math.signum(initialFirst[0]) != Math.signum(slopes[0]) ? 0.0 : Math.signum(initialFirst[0]) * Math.min(Math.abs(initialFirst[0]), 3.0 * Math.abs(slopes[0]));
        res[nDataPts - 1] = Math.signum(initialFirst[nDataPts - 1]) != Math.signum(slopes[nDataPts - 2]) ? 0.0 : Math.signum(initialFirst[nDataPts - 1]) * Math.min(Math.abs(initialFirst[nDataPts - 1]), 3.0 * Math.abs(slopes[nDataPts - 2]));
        return res;
    }

    private DoubleArray[] firstDerivativeWithSensitivityCalculator(double[] intervals, double[] slopes, double[][] slopesSensitivity, double[][] slopesAbsSensitivity, double[] initialFirst, DoubleArray[] initialFirstSense) {
        double absFirst;
        int nDataPts = intervals.length + 1;
        DoubleArray[] res = new DoubleArray[nDataPts + 1];
        double[] first = new double[nDataPts];
        double[][] pSlopes = this.parabolaSlopesCalculator(intervals, slopes);
        DoubleMatrix[] pSlopesAbsSensitivity = this.parabolaSlopesAbstSensitivityCalculator(intervals, slopesSensitivity, pSlopes);
        for (int i = 1; i < nDataPts - 1; ++i) {
            double[] tmpSense = new double[nDataPts];
            double sigInitialFirst = Math.signum(initialFirst[i]);
            if (sigInitialFirst * Math.signum(pSlopes[i - 1][1]) < 0.0) {
                first[i] = 0.0;
                Arrays.fill(tmpSense, 0.0);
            } else {
                double sig4;
                double sig3;
                double sig2;
                double sig1;
                double[] refValueWithSense = this.factoredMinWithSensitivityFinder(Math.abs(slopes[i - 1]), slopesAbsSensitivity[i - 1], Math.abs(slopes[i]), slopesAbsSensitivity[i], Math.abs(pSlopes[i - 1][1]), pSlopesAbsSensitivity[1].rowArray(i - 1));
                double[] refSense = new double[nDataPts];
                System.arraycopy(refValueWithSense, 1, refSense, 0, nDataPts);
                if (i > 1) {
                    sig1 = Math.signum(pSlopes[i - 1][1]);
                    sig2 = Math.signum(pSlopes[i - 1][0]);
                    sig3 = Math.signum(slopes[i - 1] - slopes[i - 2]);
                    sig4 = Math.signum(slopes[i] - slopes[i - 1]);
                    if (Math.abs(sig1 - sig2) <= 0.0 && Math.abs(sig2 - sig3) <= 0.0 && Math.abs(sig3 - sig4) <= 0.0) {
                        refValueWithSense = this.modifyRefValueWithSensitivity(refValueWithSense[0], refSense, Math.abs(pSlopes[i - 1][0]), pSlopesAbsSensitivity[0].rowArray(i - 2), Math.abs(pSlopes[i - 1][1]), pSlopesAbsSensitivity[1].rowArray(i - 1));
                    }
                }
                if (i < nDataPts - 2) {
                    sig1 = Math.signum(-pSlopes[i - 1][1]);
                    sig2 = Math.signum(-pSlopes[i - 1][2]);
                    sig3 = Math.signum(slopes[i + 1] - slopes[i]);
                    sig4 = Math.signum(slopes[i] - slopes[i - 1]);
                    if (Math.abs(sig1 - sig2) <= 0.0 && Math.abs(sig2 - sig3) <= 0.0 && Math.abs(sig3 - sig4) <= 0.0) {
                        refValueWithSense = this.modifyRefValueWithSensitivity(refValueWithSense[0], refSense, Math.abs(pSlopes[i - 1][2]), pSlopesAbsSensitivity[2].rowArray(i - 1), Math.abs(pSlopes[i - 1][1]), pSlopesAbsSensitivity[1].rowArray(i - 1));
                    }
                }
                if (Math.abs((absFirst = Math.abs(initialFirst[i])) - refValueWithSense[0]) < 1.0E-14) {
                    first[i] = absFirst <= refValueWithSense[0] ? initialFirst[i] : sigInitialFirst * refValueWithSense[0];
                    for (int k = 0; k < nDataPts; ++k) {
                        tmpSense[k] = 0.5 * (initialFirstSense[i].get(k) + sigInitialFirst * refValueWithSense[k + 1]);
                    }
                } else if (absFirst < refValueWithSense[0]) {
                    first[i] = initialFirst[i];
                    System.arraycopy(initialFirstSense[i].toArray(), 0, tmpSense, 0, nDataPts);
                } else {
                    first[i] = sigInitialFirst * refValueWithSense[0];
                    for (int k = 0; k < nDataPts; ++k) {
                        tmpSense[k] = sigInitialFirst * refValueWithSense[k + 1];
                    }
                }
            }
            res[i + 1] = DoubleArray.copyOf((double[])tmpSense);
        }
        double[] tmpSenseIni = new double[nDataPts];
        double sigFirstIni = Math.signum(initialFirst[0]);
        if (sigFirstIni * Math.signum(slopes[0]) < 0.0) {
            first[0] = 0.0;
            Arrays.fill(tmpSenseIni, 0.0);
        } else if (Math.abs(initialFirst[0]) > 1.0E-14 && Math.abs(slopes[0]) < 1.0E-14) {
            first[0] = 0.0;
            Arrays.fill(tmpSenseIni, 0.0);
            tmpSenseIni[0] = -1.5 / intervals[0];
            tmpSenseIni[1] = 1.5 / intervals[0];
        } else {
            double modSlope;
            double absFirst2 = Math.abs(initialFirst[0]);
            if (Math.abs(absFirst2 - (modSlope = 3.0 * Math.abs(slopes[0]))) < 1.0E-14) {
                first[0] = absFirst2 <= modSlope ? initialFirst[0] : sigFirstIni * modSlope;
                for (int k = 0; k < nDataPts; ++k) {
                    tmpSenseIni[k] = 0.5 * (initialFirstSense[0].get(k) + 3.0 * sigFirstIni * slopesAbsSensitivity[0][k]);
                }
            } else if (absFirst2 < modSlope) {
                first[0] = initialFirst[0];
                double factor = Math.abs(initialFirst[0]) < 1.0E-14 ? 0.5 : 1.0;
                for (int k = 0; k < nDataPts; ++k) {
                    tmpSenseIni[k] = factor * initialFirstSense[0].get(k);
                }
            } else {
                first[0] = sigFirstIni * modSlope;
                for (int k = 0; k < nDataPts; ++k) {
                    tmpSenseIni[k] = 3.0 * sigFirstIni * slopesAbsSensitivity[0][k];
                }
            }
        }
        res[1] = DoubleArray.copyOf((double[])tmpSenseIni);
        double[] tmpSenseFin = new double[nDataPts];
        double sigFirstFin = Math.signum(initialFirst[nDataPts - 1]);
        if (sigFirstFin * Math.signum(slopes[nDataPts - 2]) < 0.0) {
            first[nDataPts - 1] = 0.0;
            Arrays.fill(tmpSenseFin, 0.0);
        } else if (Math.abs(initialFirst[nDataPts - 1]) > 1.0E-14 && Math.abs(slopes[nDataPts - 2]) < 1.0E-14) {
            first[nDataPts - 1] = 0.0;
            Arrays.fill(tmpSenseFin, 0.0);
            tmpSenseFin[nDataPts - 2] = -1.5 / intervals[nDataPts - 2];
            tmpSenseFin[nDataPts - 1] = 1.5 / intervals[nDataPts - 2];
        } else {
            double modSlope;
            absFirst = Math.abs(initialFirst[nDataPts - 1]);
            if (Math.abs(absFirst - (modSlope = 3.0 * Math.abs(slopes[nDataPts - 2]))) < 1.0E-14) {
                first[nDataPts - 1] = absFirst <= modSlope ? initialFirst[nDataPts - 1] : sigFirstFin * modSlope;
                for (int k = 0; k < nDataPts; ++k) {
                    tmpSenseFin[k] = 0.5 * (initialFirstSense[nDataPts - 1].get(k) + 3.0 * sigFirstFin * slopesAbsSensitivity[nDataPts - 2][k]);
                }
            } else if (absFirst < modSlope) {
                first[nDataPts - 1] = initialFirst[nDataPts - 1];
                double factor = Math.abs(initialFirst[nDataPts - 1]) < 1.0E-14 ? 0.5 : 1.0;
                for (int k = 0; k < nDataPts; ++k) {
                    tmpSenseFin[k] = factor * initialFirstSense[nDataPts - 1].get(k);
                }
            } else {
                first[nDataPts - 1] = sigFirstFin * modSlope;
                for (int k = 0; k < nDataPts; ++k) {
                    tmpSenseFin[k] = 3.0 * sigFirstFin * slopesAbsSensitivity[nDataPts - 2][k];
                }
            }
        }
        res[nDataPts] = DoubleArray.copyOf((double[])tmpSenseFin);
        res[0] = DoubleArray.copyOf((double[])first);
        return res;
    }

    private double[][] parabolaSlopesCalculator(double[] intervals, double[] slopes) {
        int nData = intervals.length + 1;
        double[][] res = new double[nData - 2][3];
        res[0][0] = Double.POSITIVE_INFINITY;
        res[0][1] = (slopes[0] * intervals[1] + slopes[1] * intervals[0]) / (intervals[0] + intervals[1]);
        res[0][2] = (slopes[1] * (2.0 * intervals[1] + intervals[2]) - slopes[2] * intervals[1]) / (intervals[1] + intervals[2]);
        for (int i = 1; i < nData - 3; ++i) {
            res[i][0] = (slopes[i] * (2.0 * intervals[i] + intervals[i - 1]) - slopes[i - 1] * intervals[i]) / (intervals[i - 1] + intervals[i]);
            res[i][1] = (slopes[i] * intervals[i + 1] + slopes[i + 1] * intervals[i]) / (intervals[i] + intervals[i + 1]);
            res[i][2] = (slopes[i + 1] * (2.0 * intervals[i + 1] + intervals[i + 2]) - slopes[i + 2] * intervals[i + 1]) / (intervals[i + 1] + intervals[i + 2]);
        }
        res[nData - 3][0] = (slopes[nData - 3] * (2.0 * intervals[nData - 3] + intervals[nData - 4]) - slopes[nData - 4] * intervals[nData - 3]) / (intervals[nData - 4] + intervals[nData - 3]);
        res[nData - 3][1] = (slopes[nData - 3] * intervals[nData - 2] + slopes[nData - 2] * intervals[nData - 3]) / (intervals[nData - 3] + intervals[nData - 2]);
        res[nData - 3][2] = Double.POSITIVE_INFINITY;
        return res;
    }

    private DoubleMatrix[] parabolaSlopesAbstSensitivityCalculator(double[] intervals, double[][] slopeSensitivity, double[][] parabolaSlopes) {
        DoubleMatrix[] res = new DoubleMatrix[3];
        int nData = intervals.length + 1;
        double[][] left = new double[nData - 3][nData];
        double[][] center = new double[nData - 2][nData];
        double[][] right = new double[nData - 3][nData];
        for (int i = 0; i < nData - 3; ++i) {
            double sigLeft = Math.signum(parabolaSlopes[i + 1][0]);
            double sigCenter = Math.signum(parabolaSlopes[i][1]);
            double sigRight = Math.signum(parabolaSlopes[i][2]);
            if (sigLeft == 0.0) {
                Arrays.fill(left[i], 0.0);
            }
            if (sigCenter == 0.0) {
                Arrays.fill(center[i], 0.0);
            }
            if (sigRight == 0.0) {
                Arrays.fill(right[i], 0.0);
            }
            for (int k = 0; k < nData; ++k) {
                left[i][k] = sigLeft * (slopeSensitivity[i + 1][k] * (2.0 * intervals[i + 1] + intervals[i]) - slopeSensitivity[i][k] * intervals[i + 1]) / (intervals[i] + intervals[i + 1]);
                center[i][k] = sigCenter * (slopeSensitivity[i][k] * intervals[i + 1] + slopeSensitivity[i + 1][k] * intervals[i]) / (intervals[i] + intervals[i + 1]);
                right[i][k] = sigRight * (slopeSensitivity[i + 1][k] * (2.0 * intervals[i + 1] + intervals[i + 2]) - slopeSensitivity[i + 2][k] * intervals[i + 1]) / (intervals[i + 1] + intervals[i + 2]);
            }
        }
        double sigCenterFin = Math.signum(parabolaSlopes[nData - 3][1]);
        if (sigCenterFin == 0.0) {
            Arrays.fill(center[nData - 3], 0.0);
        }
        for (int k = 0; k < nData; ++k) {
            center[nData - 3][k] = sigCenterFin * (slopeSensitivity[nData - 3][k] * intervals[nData - 2] + slopeSensitivity[nData - 2][k] * intervals[nData - 3]) / (intervals[nData - 3] + intervals[nData - 2]);
        }
        res[0] = DoubleMatrix.copyOf((double[][])left);
        res[1] = DoubleMatrix.copyOf((double[][])center);
        res[2] = DoubleMatrix.copyOf((double[][])right);
        return res;
    }

    private DoubleMatrix[] slopesSensitivityWithAbsCalculator(double[] intervals, double[] slopes) {
        int nDataPts = intervals.length + 1;
        DoubleMatrix[] res = new DoubleMatrix[2];
        double[][] slopesSensitivity = new double[nDataPts - 1][nDataPts];
        double[][] absSlopesSensitivity = new double[nDataPts - 1][nDataPts];
        for (int i = 0; i < nDataPts - 1; ++i) {
            double sign = Math.signum(slopes[i]);
            Arrays.fill(slopesSensitivity[i], 0.0);
            Arrays.fill(absSlopesSensitivity[i], 0.0);
            slopesSensitivity[i][i] = -1.0 / intervals[i];
            slopesSensitivity[i][i + 1] = 1.0 / intervals[i];
            if (sign > 0.0) {
                absSlopesSensitivity[i][i] = slopesSensitivity[i][i];
                absSlopesSensitivity[i][i + 1] = slopesSensitivity[i][i + 1];
            }
            if (!(sign < 0.0)) continue;
            absSlopesSensitivity[i][i] = -slopesSensitivity[i][i];
            absSlopesSensitivity[i][i + 1] = -slopesSensitivity[i][i + 1];
        }
        res[0] = DoubleMatrix.copyOf((double[][])slopesSensitivity);
        res[1] = DoubleMatrix.copyOf((double[][])absSlopesSensitivity);
        return res;
    }

    private double[] factoredMinWithSensitivityFinder(double val1, double[] val1Sensitivity, double val2, double[] val2Sensitivity, double val3, double[] val3Sensitivity) {
        int i;
        int nData = val1Sensitivity.length;
        double[] res = new double[nData + 1];
        double tmpRef = 0.0;
        double[] tmpSensitivity = new double[nData];
        if (val1 < val2) {
            tmpRef = val1;
            for (i = 0; i < nData; ++i) {
                tmpSensitivity[i] = val1Sensitivity[i];
            }
        } else {
            tmpRef = val2;
            for (i = 0; i < nData; ++i) {
                tmpSensitivity[i] = val2Sensitivity[i];
            }
        }
        if (val3 == tmpRef) {
            res[0] = 3.0 * val3;
            for (i = 0; i < nData; ++i) {
                res[i + 1] = 1.5 * (val3Sensitivity[i] + tmpSensitivity[i]);
            }
        } else if (val3 < tmpRef) {
            res[0] = 3.0 * val3;
            for (i = 0; i < nData; ++i) {
                res[i + 1] = 3.0 * val3Sensitivity[i];
            }
        } else {
            res[0] = 3.0 * tmpRef;
            for (i = 0; i < nData; ++i) {
                res[i + 1] = 3.0 * tmpSensitivity[i];
            }
        }
        return res;
    }

    private double[] modifyRefValueWithSensitivity(double refVal, double[] refValSensitivity, double val1, double[] val1Sensitivity, double val2, double[] val2Sensitivity) {
        int i;
        int nData = refValSensitivity.length;
        double absVal1 = Math.abs(val1);
        double absVal2 = Math.abs(val2);
        double[] res = new double[nData + 1];
        double tmpRef = 0.0;
        double[] tmpSensitivity = new double[nData];
        if (absVal1 == absVal2) {
            tmpRef = 1.5 * absVal1;
            for (i = 0; i < nData; ++i) {
                tmpSensitivity[i] = 0.75 * (val1Sensitivity[i] + val2Sensitivity[i]);
            }
        } else if (absVal1 < absVal2) {
            tmpRef = 1.5 * absVal1;
            for (i = 0; i < nData; ++i) {
                tmpSensitivity[i] = 1.5 * val1Sensitivity[i];
            }
        } else {
            tmpRef = 1.5 * absVal2;
            for (i = 0; i < nData; ++i) {
                tmpSensitivity[i] = 1.5 * val2Sensitivity[i];
            }
        }
        if (refVal == tmpRef) {
            res[0] = refVal;
            for (i = 0; i < nData; ++i) {
                res[i + 1] = 0.5 * (refValSensitivity[i] + tmpSensitivity[i]);
            }
        } else if (refVal > tmpRef) {
            res[0] = refVal;
            for (i = 0; i < nData; ++i) {
                res[i + 1] = refValSensitivity[i];
            }
        } else {
            res[0] = tmpRef;
            for (i = 0; i < nData; ++i) {
                res[i + 1] = tmpSensitivity[i];
            }
        }
        return res;
    }

    private boolean checkSymm(double[] slopes) {
        int nDataM2 = slopes.length - 1;
        for (int i = 0; i < nDataM2; ++i) {
            if (!(Math.abs(Math.abs(slopes[i]) - Math.abs(slopes[i + 1])) < 1.0E-14)) continue;
            return true;
        }
        return false;
    }
}

