/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.google.common.primitives.Doubles;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.DoubleArrayMath;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.function.PiecewisePolynomialWithSensitivityFunction1D;
import com.opengamma.strata.math.impl.interpolation.HermiteCoefficientsProvider;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialInterpolator;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResultsWithSensitivity;
import java.util.Arrays;
import java.util.stream.IntStream;

public class NonnegativityPreservingCubicSplineInterpolator
extends PiecewisePolynomialInterpolator {
    private static final double SMALL = 1.0E-14;
    private final HermiteCoefficientsProvider _solver = new HermiteCoefficientsProvider();
    private final PiecewisePolynomialWithSensitivityFunction1D _function = new PiecewisePolynomialWithSensitivityFunction1D();
    private PiecewisePolynomialInterpolator _method;

    public NonnegativityPreservingCubicSplineInterpolator(PiecewisePolynomialInterpolator method) {
        this._method = method;
    }

    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[] yValues) {
        int i;
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValues, (String)"yValues");
        ArgChecker.isTrue((boolean)(xValues.length == yValues.length | xValues.length + 2 == yValues.length), (String)"(xValues length = yValues length) or (xValues length + 2 = yValues length)");
        ArgChecker.isTrue((xValues.length > 2 ? 1 : 0) != 0, (String)"Data points should be more than 2");
        int nDataPts = xValues.length;
        int yValuesLen = yValues.length;
        for (i = 0; i < nDataPts; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i]), (String)"xValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i]), (String)"xValues containing Infinity");
        }
        for (i = 0; i < yValuesLen; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(yValues[i]), (String)"yValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(yValues[i]), (String)"yValues containing Infinity");
        }
        double[] xValuesSrt = Arrays.copyOf(xValues, nDataPts);
        double[] yValuesSrt = nDataPts == yValuesLen ? Arrays.copyOf(yValues, nDataPts) : Arrays.copyOfRange(yValues, 1, nDataPts + 1);
        DoubleArrayMath.sortPairs((double[])xValuesSrt, (double[])yValuesSrt);
        ArgChecker.noDuplicatesSorted((double[])xValuesSrt, (String)"xValues");
        double[] intervals = this._solver.intervalsCalculator(xValuesSrt);
        double[] slopes = this._solver.slopesCalculator(yValuesSrt, intervals);
        PiecewisePolynomialResult result = this._method.interpolate(xValues, yValues);
        ArgChecker.isTrue((result.getOrder() == 4 ? 1 : 0) != 0, (String)"Primary interpolant is not cubic");
        double[] initialFirst = this._function.differentiate(result, xValuesSrt).rowArray(0);
        double[] first = this.firstDerivativeCalculator(yValuesSrt, intervals, slopes, initialFirst);
        double[][] coefs = this._solver.solve(yValuesSrt, intervals, slopes, first);
        for (int i2 = 0; i2 < nDataPts - 1; ++i2) {
            for (int j = 0; j < 4; ++j) {
                ArgChecker.isFalse((boolean)Double.isNaN(coefs[i2][j]), (String)"Too large input");
                ArgChecker.isFalse((boolean)Double.isInfinite(coefs[i2][j]), (String)"Too large input");
            }
        }
        return new PiecewisePolynomialResult(DoubleArray.copyOf((double[])xValuesSrt), DoubleMatrix.copyOf((double[][])coefs), 4, 1);
    }

    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[][] yValuesMatrix) {
        int i;
        int i2;
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValuesMatrix, (String)"yValuesMatrix");
        ArgChecker.isTrue((boolean)(xValues.length == yValuesMatrix[0].length | xValues.length + 2 == yValuesMatrix[0].length), (String)"(xValues length = yValuesMatrix's row vector length) or (xValues length + 2 = yValuesMatrix's row vector length)");
        ArgChecker.isTrue((xValues.length > 2 ? 1 : 0) != 0, (String)"Data points should be more than 2");
        int nDataPts = xValues.length;
        int yValuesLen = yValuesMatrix[0].length;
        int dim = yValuesMatrix.length;
        for (i2 = 0; i2 < nDataPts; ++i2) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i2]), (String)"xValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i2]), (String)"xValues containing Infinity");
        }
        for (i2 = 0; i2 < yValuesLen; ++i2) {
            for (int j = 0; j < dim; ++j) {
                ArgChecker.isFalse((boolean)Double.isNaN(yValuesMatrix[j][i2]), (String)"yValuesMatrix containing NaN");
                ArgChecker.isFalse((boolean)Double.isInfinite(yValuesMatrix[j][i2]), (String)"yValuesMatrix containing Infinity");
            }
        }
        double[] xValuesSrt = Arrays.copyOf(xValues, nDataPts);
        int[] sortedPositions = IntStream.range(0, nDataPts).toArray();
        DoubleArrayMath.sortPairs((double[])xValuesSrt, (int[])sortedPositions);
        ArgChecker.noDuplicatesSorted((double[])xValuesSrt, (String)"xValues");
        DoubleMatrix[] coefMatrix = new DoubleMatrix[dim];
        for (int i3 = 0; i3 < dim; ++i3) {
            double[] yValuesSrt = nDataPts == yValuesLen ? DoubleArrayMath.reorderedCopy((double[])yValuesMatrix[i3], (int[])sortedPositions) : DoubleArrayMath.reorderedCopy((double[])Arrays.copyOfRange(yValuesMatrix[i3], 1, nDataPts + 1), (int[])sortedPositions);
            double[] intervals = this._solver.intervalsCalculator(xValuesSrt);
            double[] slopes = this._solver.slopesCalculator(yValuesSrt, intervals);
            PiecewisePolynomialResult result = this._method.interpolate(xValues, yValuesMatrix[i3]);
            ArgChecker.isTrue((result.getOrder() == 4 ? 1 : 0) != 0, (String)"Primary interpolant is not cubic");
            double[] initialFirst = this._function.differentiate(result, xValuesSrt).rowArray(0);
            double[] first = this.firstDerivativeCalculator(yValuesSrt, intervals, slopes, initialFirst);
            coefMatrix[i3] = DoubleMatrix.copyOf((double[][])this._solver.solve(yValuesSrt, intervals, slopes, first));
        }
        int nIntervals = coefMatrix[0].rowCount();
        int nCoefs = coefMatrix[0].columnCount();
        double[][] resMatrix = new double[dim * nIntervals][nCoefs];
        for (i = 0; i < nIntervals; ++i) {
            for (int j = 0; j < dim; ++j) {
                resMatrix[dim * i + j] = coefMatrix[j].row(i).toArray();
            }
        }
        for (i = 0; i < nIntervals * dim; ++i) {
            for (int j = 0; j < nCoefs; ++j) {
                ArgChecker.isFalse((boolean)Double.isNaN(resMatrix[i][j]), (String)"Too large input");
                ArgChecker.isFalse((boolean)Double.isInfinite(resMatrix[i][j]), (String)"Too large input");
            }
        }
        return new PiecewisePolynomialResult(DoubleArray.copyOf((double[])xValuesSrt), DoubleMatrix.copyOf((double[][])resMatrix), nCoefs, dim);
    }

    @Override
    public PiecewisePolynomialResultsWithSensitivity interpolateWithSensitivity(double[] xValues, double[] yValues) {
        int i;
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValues, (String)"yValues");
        ArgChecker.isTrue((boolean)(xValues.length == yValues.length | xValues.length + 2 == yValues.length), (String)"(xValues length = yValues length) or (xValues length + 2 = yValues length)");
        ArgChecker.isTrue((xValues.length > 2 ? 1 : 0) != 0, (String)"Data points should be more than 2");
        int nDataPts = xValues.length;
        int yValuesLen = yValues.length;
        for (i = 0; i < nDataPts; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i]), (String)"xValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i]), (String)"xValues containing Infinity");
        }
        for (i = 0; i < yValuesLen; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(yValues[i]), (String)"yValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(yValues[i]), (String)"yValues containing Infinity");
        }
        ArgChecker.noDuplicates((double[])xValues, (String)"xValues");
        double[] yValuesSrt = nDataPts == yValuesLen ? Arrays.copyOf(yValues, nDataPts) : Arrays.copyOfRange(yValues, 1, nDataPts + 1);
        double[] intervals = this._solver.intervalsCalculator(xValues);
        double[] slopes = this._solver.slopesCalculator(yValuesSrt, intervals);
        PiecewisePolynomialResultsWithSensitivity resultWithSensitivity = this._method.interpolateWithSensitivity(xValues, yValues);
        ArgChecker.isTrue((resultWithSensitivity.getOrder() == 4 ? 1 : 0) != 0, (String)"Primary interpolant is not cubic");
        double[] initialFirst = this._function.differentiate((PiecewisePolynomialResult)resultWithSensitivity, xValues).rowArray(0);
        double[][] slopeSensitivity = this._solver.slopeSensitivityCalculator(intervals);
        DoubleArray[] initialFirstSense = this._function.differentiateNodeSensitivity(resultWithSensitivity, xValues);
        DoubleArray[] firstWithSensitivity = this.firstDerivativeWithSensitivityCalculator(yValuesSrt, intervals, initialFirst, initialFirstSense);
        DoubleMatrix[] resMatrix = this._solver.solveWithSensitivity(yValuesSrt, intervals, slopes, slopeSensitivity, firstWithSensitivity);
        for (int k = 0; k < nDataPts; ++k) {
            DoubleMatrix m = resMatrix[k];
            int rows = m.rowCount();
            int cols = m.columnCount();
            for (int i2 = 0; i2 < rows; ++i2) {
                for (int j = 0; j < cols; ++j) {
                    ArgChecker.isTrue((boolean)Doubles.isFinite((double)m.get(i2, j)), (String)"Matrix contains a NaN or infinite");
                }
            }
        }
        DoubleMatrix coefMatrix = resMatrix[0];
        DoubleMatrix[] coefSenseMatrix = new DoubleMatrix[nDataPts - 1];
        System.arraycopy(resMatrix, 1, coefSenseMatrix, 0, nDataPts - 1);
        int nCoefs = coefMatrix.columnCount();
        return new PiecewisePolynomialResultsWithSensitivity(DoubleArray.copyOf((double[])xValues), coefMatrix, nCoefs, 1, coefSenseMatrix);
    }

    @Override
    public PiecewisePolynomialInterpolator getPrimaryMethod() {
        return this._method;
    }

    private double[] firstDerivativeCalculator(double[] yValues, double[] intervals, double[] slopes, double[] initialFirst) {
        int nDataPts = yValues.length;
        double[] res = new double[nDataPts];
        for (int i = 1; i < nDataPts - 1; ++i) {
            double tau = Math.signum(yValues[i]);
            res[i] = tau == 0.0 ? initialFirst[i] : Math.min(3.0 * tau * yValues[i] / intervals[i - 1], Math.max(-3.0 * tau * yValues[i] / intervals[i], tau * initialFirst[i])) / tau;
        }
        double tauIni = Math.signum(yValues[0]);
        double tauFin = Math.signum(yValues[nDataPts - 1]);
        res[0] = tauIni == 0.0 ? initialFirst[0] : Math.min(3.0 * tauIni * yValues[0] / intervals[0], Math.max(-3.0 * tauIni * yValues[0] / intervals[0], tauIni * initialFirst[0])) / tauIni;
        res[nDataPts - 1] = tauFin == 0.0 ? initialFirst[nDataPts - 1] : Math.min(3.0 * tauFin * yValues[nDataPts - 1] / intervals[nDataPts - 2], Math.max(-3.0 * tauFin * yValues[nDataPts - 1] / intervals[nDataPts - 2], tauFin * initialFirst[nDataPts - 1])) / tauFin;
        return res;
    }

    private DoubleArray[] firstDerivativeWithSensitivityCalculator(double[] yValues, double[] intervals, double[] initialFirst, DoubleArray[] initialFirstSense) {
        int nDataPts = yValues.length;
        DoubleArray[] res = new DoubleArray[nDataPts + 1];
        double[] newFirst = new double[nDataPts];
        for (int i = 1; i < nDataPts - 1; ++i) {
            int k;
            double tau = Math.signum(yValues[i]);
            double lower = -3.0 * tau * yValues[i] / intervals[i];
            double upper = 3.0 * tau * yValues[i] / intervals[i - 1];
            double ref = tau * initialFirst[i];
            double[] tmp = new double[nDataPts];
            Arrays.fill(tmp, 0.0);
            if (Math.abs(ref - lower) < 1.0E-14 && tau != 0.0) {
                newFirst[i] = ref >= lower ? initialFirst[i] : lower / tau;
                for (k = 0; k < nDataPts; ++k) {
                    tmp[k] = 0.5 * initialFirstSense[i].get(k);
                }
                int n = i;
                tmp[n] = tmp[n] - 1.5 / intervals[i];
            } else if (ref < lower) {
                newFirst[i] = lower / tau;
                tmp[i] = -3.0 / intervals[i];
            } else if (Math.abs(ref - upper) < 1.0E-14 && tau != 0.0) {
                newFirst[i] = ref <= upper ? initialFirst[i] : upper / tau;
                for (k = 0; k < nDataPts; ++k) {
                    tmp[k] = 0.5 * initialFirstSense[i].get(k);
                }
                int n = i;
                tmp[n] = tmp[n] + 1.5 / intervals[i - 1];
            } else if (ref > upper) {
                newFirst[i] = upper / tau;
                tmp[i] = 3.0 / intervals[i - 1];
            } else {
                newFirst[i] = initialFirst[i];
                System.arraycopy(initialFirstSense[i].toArray(), 0, tmp, 0, nDataPts);
            }
            res[i + 1] = DoubleArray.copyOf((double[])tmp);
        }
        double tauIni = Math.signum(yValues[0]);
        double lowerIni = -3.0 * tauIni * yValues[0] / intervals[0];
        double upperIni = 3.0 * tauIni * yValues[0] / intervals[0];
        double refIni = tauIni * initialFirst[0];
        double[] tmpIni = new double[nDataPts];
        Arrays.fill(tmpIni, 0.0);
        if (Math.abs(refIni - lowerIni) < 1.0E-14 && tauIni != 0.0) {
            newFirst[0] = refIni >= lowerIni ? initialFirst[0] : lowerIni / tauIni;
            for (int k = 0; k < nDataPts; ++k) {
                tmpIni[k] = 0.5 * initialFirstSense[0].get(k);
            }
            tmpIni[0] = tmpIni[0] - 1.5 / intervals[0];
        } else if (refIni < lowerIni) {
            newFirst[0] = lowerIni / tauIni;
            tmpIni[0] = -3.0 / intervals[0];
        } else if (Math.abs(refIni - upperIni) < 1.0E-14 && tauIni != 0.0) {
            newFirst[0] = refIni <= upperIni ? initialFirst[0] : upperIni / tauIni;
            for (int k = 0; k < nDataPts; ++k) {
                tmpIni[k] = 0.5 * initialFirstSense[0].get(k);
            }
            tmpIni[0] = tmpIni[0] + 1.5 / intervals[0];
        } else if (refIni > upperIni) {
            newFirst[0] = upperIni / tauIni;
            tmpIni[0] = 3.0 / intervals[0];
        } else {
            newFirst[0] = initialFirst[0];
            System.arraycopy(initialFirstSense[0].toArray(), 0, tmpIni, 0, nDataPts);
        }
        res[1] = DoubleArray.copyOf((double[])tmpIni);
        double tauFin = Math.signum(yValues[nDataPts - 1]);
        double lowerFin = -3.0 * tauFin * yValues[nDataPts - 1] / intervals[nDataPts - 2];
        double upperFin = 3.0 * tauFin * yValues[nDataPts - 1] / intervals[nDataPts - 2];
        double refFin = tauFin * initialFirst[nDataPts - 1];
        double[] tmpFin = new double[nDataPts];
        Arrays.fill(tmpFin, 0.0);
        if (Math.abs(refFin - lowerFin) < 1.0E-14 && tauFin != 0.0) {
            newFirst[nDataPts - 1] = refFin >= lowerFin ? initialFirst[nDataPts - 1] : lowerFin / tauFin;
            for (int k = 0; k < nDataPts; ++k) {
                tmpFin[k] = 0.5 * initialFirstSense[nDataPts - 1].get(k);
            }
            int n = nDataPts - 1;
            tmpFin[n] = tmpFin[n] - 1.5 / intervals[nDataPts - 2];
        } else if (refFin < lowerFin) {
            newFirst[nDataPts - 1] = lowerFin / tauFin;
            tmpFin[nDataPts - 1] = -3.0 / intervals[nDataPts - 2];
        } else if (Math.abs(refFin - upperFin) < 1.0E-14 && tauFin != 0.0) {
            newFirst[nDataPts - 1] = refFin <= upperFin ? initialFirst[nDataPts - 1] : upperFin / tauFin;
            for (int k = 0; k < nDataPts; ++k) {
                tmpFin[k] = 0.5 * initialFirstSense[nDataPts - 1].get(k);
            }
            int n = nDataPts - 1;
            tmpFin[n] = tmpFin[n] + 1.5 / intervals[nDataPts - 2];
        } else if (refFin > upperFin) {
            newFirst[nDataPts - 1] = upperFin / tauFin;
            tmpFin[nDataPts - 1] = 3.0 / intervals[nDataPts - 2];
        } else {
            newFirst[nDataPts - 1] = initialFirst[nDataPts - 1];
            System.arraycopy(initialFirstSense[nDataPts - 1].toArray(), 0, tmpFin, 0, nDataPts);
        }
        res[nDataPts] = DoubleArray.copyOf((double[])tmpFin);
        res[0] = DoubleArray.copyOf((double[])newFirst);
        return res;
    }
}

