/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;

public class PiecewisePolynomialResult {
    private DoubleArray _knots;
    private DoubleMatrix _coefMatrix;
    private int _nIntervals;
    private int _order;
    private int _dim;

    public PiecewisePolynomialResult(DoubleArray knots, DoubleMatrix coefMatrix, int order, int dim) {
        this._knots = knots;
        this._coefMatrix = coefMatrix;
        this._nIntervals = knots.size() - 1;
        this._order = order;
        this._dim = dim;
    }

    public DoubleArray getKnots() {
        return this._knots;
    }

    public DoubleMatrix getCoefMatrix() {
        return this._coefMatrix;
    }

    public int getNumberOfIntervals() {
        return this._nIntervals;
    }

    public int getOrder() {
        return this._order;
    }

    public int getDimensions() {
        return this._dim;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._coefMatrix.hashCode();
        result = 31 * result + this._dim;
        result = 31 * result + this._knots.hashCode();
        result = 31 * result + this._order;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PiecewisePolynomialResult)) {
            return false;
        }
        PiecewisePolynomialResult other = (PiecewisePolynomialResult)obj;
        if (!this._coefMatrix.equals((Object)other._coefMatrix)) {
            return false;
        }
        if (this._dim != other._dim) {
            return false;
        }
        if (!this._knots.equals((Object)other._knots)) {
            return false;
        }
        return this._order == other._order;
    }
}

