/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.math.impl.interpolation.PolynomialsLeastSquaresFitterResult;
import com.opengamma.strata.math.impl.linearalgebra.QRDecompositionCommons;
import com.opengamma.strata.math.impl.linearalgebra.QRDecompositionResult;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebraFactory;
import com.opengamma.strata.math.impl.regression.LeastSquaresRegressionResult;
import com.opengamma.strata.math.impl.statistics.descriptive.MeanCalculator;
import com.opengamma.strata.math.impl.statistics.descriptive.SampleStandardDeviationCalculator;
import java.util.Arrays;
import java.util.function.Function;

public class PolynomialsLeastSquaresFitter {
    private QRDecompositionResult _qrResult;
    private final double[] _renorm = new double[2];

    public LeastSquaresRegressionResult regress(double[] xData, double[] yData, int degree) {
        return this.regress(xData, yData, degree, false);
    }

    public PolynomialsLeastSquaresFitterResult regressVerbose(double[] xData, double[] yData, int degree, boolean normalize) {
        LeastSquaresRegressionResult result = this.regress(xData, yData, degree, normalize);
        int nData = xData.length;
        DoubleMatrix rMatriX = this._qrResult.getR();
        DoubleArray resResult = DoubleArray.copyOf((double[])result.getResiduals());
        double resNorm = MatrixAlgebraFactory.OG_ALGEBRA.getNorm2((Matrix)resResult);
        if (normalize) {
            return new PolynomialsLeastSquaresFitterResult(result.getBetas(), rMatriX, nData - degree - 1, resNorm, this._renorm);
        }
        return new PolynomialsLeastSquaresFitterResult(result.getBetas(), rMatriX, nData - degree - 1, resNorm);
    }

    private LeastSquaresRegressionResult regress(double[] xData, double[] yData, int degree, boolean normalize) {
        int i;
        ArgChecker.notNull((Object)xData, (String)"xData");
        ArgChecker.notNull((Object)yData, (String)"yData");
        ArgChecker.isTrue((degree >= 0 ? 1 : 0) != 0, (String)"Minus degree");
        ArgChecker.isTrue((xData.length == yData.length ? 1 : 0) != 0, (String)"xData length should be the same as yData length");
        ArgChecker.isTrue((xData.length > degree ? 1 : 0) != 0, (String)"Not enough amount of data");
        int nData = xData.length;
        for (i = 0; i < nData; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xData[i]), (String)"xData containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xData[i]), (String)"xData containing Infinity");
            ArgChecker.isFalse((boolean)Double.isNaN(yData[i]), (String)"yData containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(yData[i]), (String)"yData containing Infinity");
        }
        for (i = 0; i < nData; ++i) {
            for (int j = i + 1; j < nData; ++j) {
                ArgChecker.isFalse((xData[i] == xData[j] && yData[i] != yData[j] ? 1 : 0) != 0, (String)"Two distinct data on x=const. line");
            }
        }
        int nRepeat = 0;
        for (int i2 = 0; i2 < nData; ++i2) {
            for (int j = i2 + 1; j < nData; ++j) {
                if (xData[i2] != xData[j] || yData[i2] != yData[j]) continue;
                ++nRepeat;
            }
        }
        ArgChecker.isFalse((nRepeat > nData - degree - 1 ? 1 : 0) != 0, (String)"Too many repeated data");
        double[][] tmpMatrix = new double[nData][degree + 1];
        if (normalize) {
            double[] normData = this.normaliseData(xData);
            for (int i3 = 0; i3 < nData; ++i3) {
                for (int j = 0; j < degree + 1; ++j) {
                    tmpMatrix[i3][j] = Math.pow(normData[i3], j);
                }
            }
        } else {
            for (int i4 = 0; i4 < nData; ++i4) {
                for (int j = 0; j < degree + 1; ++j) {
                    tmpMatrix[i4][j] = Math.pow(xData[i4], j);
                }
            }
        }
        DoubleMatrix xDataMatrix = DoubleMatrix.copyOf((double[][])tmpMatrix);
        DoubleArray yDataVector = DoubleArray.copyOf((double[])yData);
        double vandNorm = MatrixAlgebraFactory.COMMONS_ALGEBRA.getNorm2((Matrix)xDataMatrix);
        ArgChecker.isFalse((vandNorm > 1.0E9 ? 1 : 0) != 0, (String)"Too large input data or too many degrees");
        return this.regress(xDataMatrix, yDataVector, nData, degree);
    }

    private LeastSquaresRegressionResult regress(DoubleMatrix xDataMatrix, DoubleArray yDataVector, int nData, int degree) {
        int i;
        QRDecompositionCommons qrComm = new QRDecompositionCommons();
        Object decompResult = qrComm.apply(xDataMatrix);
        this._qrResult = (QRDecompositionResult)decompResult;
        DoubleMatrix qMatrix = this._qrResult.getQ();
        DoubleMatrix rMatrix = this._qrResult.getR();
        double[] betas = this.backSubstitution(qMatrix, rMatrix, yDataVector, degree);
        double[] residuals = this.residualsSolver(xDataMatrix, betas, yDataVector);
        for (i = 0; i < degree + 1; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(betas[i]), (String)"Input is too large or small");
        }
        for (i = 0; i < nData; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(residuals[i]), (String)"Input is too large or small");
        }
        return new LeastSquaresRegressionResult(betas, residuals, 0.0, null, 0.0, 0.0, null, null, true);
    }

    private double[] backSubstitution(DoubleMatrix qMatrix, DoubleMatrix rMatrix, DoubleArray yDataVector, int degree) {
        double[] res = new double[degree + 1];
        Arrays.fill(res, 0.0);
        DoubleMatrix tpMatrix = MatrixAlgebraFactory.OG_ALGEBRA.getTranspose((Matrix)qMatrix);
        DoubleArray yDataVecConv = (DoubleArray)MatrixAlgebraFactory.OG_ALGEBRA.multiply((Matrix)tpMatrix, (Matrix)yDataVector);
        for (int i = 0; i < degree + 1; ++i) {
            double tmp = 0.0;
            for (int j = 0; j < i; ++j) {
                tmp -= rMatrix.get(degree - i, degree - j) * res[degree - j] / rMatrix.get(degree - i, degree - i);
            }
            res[degree - i] = yDataVecConv.get(degree - i) / rMatrix.get(degree - i, degree - i) + tmp;
        }
        return res;
    }

    private double[] residualsSolver(DoubleMatrix xDataMatrix, double[] betas, DoubleArray yDataVector) {
        DoubleArray betasVector = DoubleArray.copyOf((double[])betas);
        DoubleArray modelValuesVector = (DoubleArray)MatrixAlgebraFactory.OG_ALGEBRA.multiply((Matrix)xDataMatrix, (Matrix)betasVector);
        DoubleArray res = (DoubleArray)MatrixAlgebraFactory.OG_ALGEBRA.subtract((Matrix)yDataVector, (Matrix)modelValuesVector);
        return res.toArray();
    }

    private double[] normaliseData(double[] xData) {
        int nData = xData.length;
        double[] res = new double[nData];
        Function<double[], Double> calculator = new MeanCalculator();
        this._renorm[0] = (Double)calculator.apply(xData);
        calculator = new SampleStandardDeviationCalculator();
        this._renorm[1] = calculator.apply(xData);
        double tmp = this._renorm[0] / this._renorm[1];
        for (int i = 0; i < nData; ++i) {
            res[i] = xData[i] / this._renorm[1] - tmp;
        }
        return res;
    }
}

