/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.linearalgebra;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.linearalgebra.CholeskyDecompositionResult;
import com.opengamma.strata.math.impl.util.CommonsMathWrapper;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.RealVector;

public class CholeskyDecompositionCommonsResult
implements CholeskyDecompositionResult {
    private final double _determinant;
    private final DoubleMatrix _l;
    private final DoubleMatrix _lt;
    private final DecompositionSolver _solver;

    public CholeskyDecompositionCommonsResult(CholeskyDecomposition ch) {
        ArgChecker.notNull((Object)ch, (String)"Cholesky decomposition");
        this._determinant = ch.getDeterminant();
        this._l = CommonsMathWrapper.unwrap(ch.getL());
        this._lt = CommonsMathWrapper.unwrap(ch.getLT());
        this._solver = ch.getSolver();
    }

    @Override
    public DoubleArray solve(DoubleArray b) {
        ArgChecker.notNull((Object)b, (String)"b");
        return CommonsMathWrapper.unwrap(this._solver.solve(CommonsMathWrapper.wrap(b)));
    }

    @Override
    public double[] solve(double[] b) {
        ArgChecker.notNull((Object)b, (String)"b");
        return this._solver.solve((RealVector)new ArrayRealVector(b)).toArray();
    }

    @Override
    public DoubleMatrix solve(DoubleMatrix b) {
        ArgChecker.notNull((Object)b, (String)"b");
        return CommonsMathWrapper.unwrap(this._solver.solve(CommonsMathWrapper.wrap(b)));
    }

    @Override
    public DoubleMatrix getL() {
        return this._l;
    }

    @Override
    public DoubleMatrix getLT() {
        return this._lt;
    }

    @Override
    public double getDeterminant() {
        return this._determinant;
    }
}

