/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.linearalgebra;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.math.impl.linearalgebra.CholeskyDecompositionResult;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebra;
import com.opengamma.strata.math.impl.matrix.OGMatrixAlgebra;

public class CholeskyDecompositionOpenGammaResult
implements CholeskyDecompositionResult {
    private static final MatrixAlgebra ALGEBRA = new OGMatrixAlgebra();
    private final double[][] _lArray;
    private final DoubleMatrix _l;
    private final DoubleMatrix _lT;
    private double _determinant;

    public CholeskyDecompositionOpenGammaResult(double[][] lArray) {
        this._lArray = lArray;
        this._l = DoubleMatrix.copyOf((double[][])this._lArray);
        this._lT = ALGEBRA.getTranspose((Matrix)this._l);
        this._determinant = 1.0;
        for (int loopdiag = 0; loopdiag < this._lArray.length; ++loopdiag) {
            this._determinant *= this._lArray[loopdiag][loopdiag] * this._lArray[loopdiag][loopdiag];
        }
    }

    @Override
    public double[] solve(double[] b) {
        int j;
        int looprow;
        int dim = b.length;
        ArgChecker.isTrue((dim == this._lArray.length ? 1 : 0) != 0, (String)"b array of incorrect size");
        double[] x = new double[dim];
        System.arraycopy(b, 0, x, 0, dim);
        for (looprow = 0; looprow < dim; ++looprow) {
            int n = looprow;
            x[n] = x[n] / this._lArray[looprow][looprow];
            for (j = looprow + 1; j < dim; ++j) {
                int n2 = j;
                x[n2] = x[n2] - x[looprow] * this._lArray[j][looprow];
            }
        }
        for (looprow = dim - 1; looprow >= 0; --looprow) {
            int n = looprow;
            x[n] = x[n] / this._lArray[looprow][looprow];
            for (j = 0; j < looprow; ++j) {
                int n3 = j;
                x[n3] = x[n3] - x[looprow] * this._lArray[looprow][j];
            }
        }
        return x;
    }

    @Override
    public DoubleMatrix solve(DoubleMatrix b) {
        int j;
        int looprow;
        int loopcol;
        int nbRow = b.rowCount();
        int nbCol = b.columnCount();
        ArgChecker.isTrue((nbRow == this._lArray.length ? 1 : 0) != 0, (String)"b array of incorrect size");
        double[][] x = b.toArray();
        for (loopcol = 0; loopcol < nbCol; ++loopcol) {
            for (looprow = 0; looprow < nbRow; ++looprow) {
                double[] dArray = x[looprow];
                int n = loopcol;
                dArray[n] = dArray[n] / this._lArray[looprow][looprow];
                for (j = looprow + 1; j < nbRow; ++j) {
                    double[] dArray2 = x[j];
                    int n2 = loopcol;
                    dArray2[n2] = dArray2[n2] - x[looprow][loopcol] * this._lArray[j][looprow];
                }
            }
        }
        for (loopcol = 0; loopcol < nbCol; ++loopcol) {
            for (looprow = nbRow - 1; looprow >= 0; --looprow) {
                double[] dArray = x[looprow];
                int n = loopcol;
                dArray[n] = dArray[n] / this._lArray[looprow][looprow];
                for (j = 0; j < looprow; ++j) {
                    double[] dArray3 = x[j];
                    int n3 = loopcol;
                    dArray3[n3] = dArray3[n3] - x[looprow][loopcol] * this._lArray[looprow][j];
                }
            }
        }
        return DoubleMatrix.copyOf((double[][])x);
    }

    @Override
    public DoubleMatrix getL() {
        return this._l;
    }

    @Override
    public DoubleMatrix getLT() {
        return this._lT;
    }

    @Override
    public double getDeterminant() {
        return this._determinant;
    }
}

