/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.linearalgebra;

import com.opengamma.strata.math.impl.linearalgebra.LUDecompositionCommons;
import com.opengamma.strata.math.impl.linearalgebra.QRDecompositionCommons;
import com.opengamma.strata.math.impl.linearalgebra.SVDecompositionCommons;
import com.opengamma.strata.math.linearalgebra.Decomposition;
import java.util.HashMap;
import java.util.Map;

public final class DecompositionFactory {
    public static final String LU_COMMONS_NAME = "LU_COMMONS";
    public static final String QR_COMMONS_NAME = "QR_COMMONS";
    public static final String SV_COMMONS_NAME = "SV_COMMONS";
    public static final Decomposition<?> LU_COMMONS = new LUDecompositionCommons();
    public static final Decomposition<?> QR_COMMONS = new QRDecompositionCommons();
    public static final Decomposition<?> SV_COMMONS = new SVDecompositionCommons();
    private static final Map<String, Decomposition<?>> STATIC_INSTANCES = new HashMap();
    private static final Map<Class<?>, String> INSTANCE_NAMES;

    private DecompositionFactory() {
    }

    public static Decomposition<?> getDecomposition(String decompositionName) {
        Decomposition<?> decomposition = STATIC_INSTANCES.get(decompositionName);
        if (decomposition != null) {
            return decomposition;
        }
        throw new IllegalArgumentException("Could not get decomposition " + decompositionName);
    }

    public static String getDecompositionName(Decomposition<?> decomposition) {
        if (decomposition == null) {
            return null;
        }
        return INSTANCE_NAMES.get(decomposition.getClass());
    }

    static {
        STATIC_INSTANCES.put(LU_COMMONS_NAME, LU_COMMONS);
        STATIC_INSTANCES.put(QR_COMMONS_NAME, QR_COMMONS);
        STATIC_INSTANCES.put(SV_COMMONS_NAME, SV_COMMONS);
        INSTANCE_NAMES = new HashMap();
        INSTANCE_NAMES.put(LU_COMMONS.getClass(), LU_COMMONS_NAME);
        INSTANCE_NAMES.put(QR_COMMONS.getClass(), QR_COMMONS_NAME);
        INSTANCE_NAMES.put(SV_COMMONS.getClass(), SV_COMMONS_NAME);
    }
}

