/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.linearalgebra;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.linearalgebra.MatrixValidate;
import com.opengamma.strata.math.impl.linearalgebra.SVDecompositionCommonsResult;
import com.opengamma.strata.math.impl.linearalgebra.SVDecompositionResult;
import com.opengamma.strata.math.impl.util.CommonsMathWrapper;
import com.opengamma.strata.math.linearalgebra.Decomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;

public class SVDecompositionCommons
implements Decomposition<SVDecompositionResult> {
    @Override
    public SVDecompositionResult apply(DoubleMatrix x) {
        ArgChecker.notNull((Object)x, (String)"x");
        MatrixValidate.notNaNOrInfinite(x);
        RealMatrix commonsMatrix = CommonsMathWrapper.wrap(x);
        SingularValueDecomposition svd = new SingularValueDecomposition(commonsMatrix);
        return new SVDecompositionCommonsResult(svd);
    }
}

