/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.linearalgebra;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.linearalgebra.SVDecompositionResult;
import com.opengamma.strata.math.impl.util.CommonsMathWrapper;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularValueDecomposition;

public class SVDecompositionCommonsResult
implements SVDecompositionResult {
    private final double _condition;
    private final double _norm;
    private final int _rank;
    private final DoubleMatrix _s;
    private final double[] _singularValues;
    private final DoubleMatrix _u;
    private final DoubleMatrix _v;
    private final DoubleMatrix _uTranspose;
    private final DoubleMatrix _vTranspose;
    private final DecompositionSolver _solver;

    public SVDecompositionCommonsResult(SingularValueDecomposition svd) {
        ArgChecker.notNull((Object)svd, (String)"svd");
        this._condition = svd.getConditionNumber();
        this._norm = svd.getNorm();
        this._rank = svd.getRank();
        this._s = CommonsMathWrapper.unwrap(svd.getS());
        this._singularValues = svd.getSingularValues();
        this._u = CommonsMathWrapper.unwrap(svd.getU());
        this._uTranspose = CommonsMathWrapper.unwrap(svd.getUT());
        this._v = CommonsMathWrapper.unwrap(svd.getV());
        this._vTranspose = CommonsMathWrapper.unwrap(svd.getVT());
        this._solver = svd.getSolver();
    }

    @Override
    public double getConditionNumber() {
        return this._condition;
    }

    @Override
    public double getNorm() {
        return this._norm;
    }

    @Override
    public int getRank() {
        return this._rank;
    }

    @Override
    public DoubleMatrix getS() {
        return this._s;
    }

    @Override
    public double[] getSingularValues() {
        return this._singularValues;
    }

    @Override
    public DoubleMatrix getU() {
        return this._u;
    }

    @Override
    public DoubleMatrix getUT() {
        return this._uTranspose;
    }

    @Override
    public DoubleMatrix getV() {
        return this._v;
    }

    @Override
    public DoubleMatrix getVT() {
        return this._vTranspose;
    }

    @Override
    public DoubleArray solve(DoubleArray b) {
        ArgChecker.notNull((Object)b, (String)"b");
        return CommonsMathWrapper.unwrap(this._solver.solve(CommonsMathWrapper.wrap(b)));
    }

    @Override
    public double[] solve(double[] b) {
        ArgChecker.notNull((Object)b, (String)"b");
        return this._solver.solve((RealVector)new ArrayRealVector(b)).toArray();
    }

    @Override
    public DoubleMatrix solve(DoubleMatrix b) {
        ArgChecker.notNull((Object)b, (String)"b");
        return CommonsMathWrapper.unwrap(this._solver.solve(CommonsMathWrapper.wrap(b)));
    }
}

