/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.minimization;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.TrigonometricFunctionUtils;
import com.opengamma.strata.math.impl.minimization.ParameterLimitsTransform;

public class DoubleRangeLimitTransform
implements ParameterLimitsTransform {
    private static final double TANH_MAX = 25.0;
    private final double _lower;
    private final double _upper;
    private final double _scale;
    private final double _mid;

    public DoubleRangeLimitTransform(double lower, double upper) {
        ArgChecker.isTrue((upper > lower ? 1 : 0) != 0, (String)"upper limit must be greater than lower");
        this._lower = lower;
        this._upper = upper;
        this._mid = (lower + upper) / 2.0;
        this._scale = (upper - lower) / 2.0;
    }

    @Override
    public double inverseTransform(double y) {
        if (y > 25.0) {
            return this._upper;
        }
        if (y < -25.0) {
            return this._lower;
        }
        return this._mid + this._scale * TrigonometricFunctionUtils.tanh(y);
    }

    @Override
    public double transform(double x) {
        ArgChecker.isTrue((x <= this._upper && x >= this._lower ? 1 : 0) != 0, (String)"parameter out of range");
        if (x == this._upper) {
            return 25.0;
        }
        if (x == this._lower) {
            return -25.0;
        }
        return TrigonometricFunctionUtils.atanh((x - this._mid) / this._scale);
    }

    @Override
    public double inverseTransformGradient(double y) {
        if (y > 25.0 || y < -25.0) {
            return 0.0;
        }
        double p = 2.0 * y;
        double ep = Math.exp(p);
        double epp1 = ep + 1.0;
        return this._scale * 4.0 * ep / (epp1 * epp1);
    }

    @Override
    public double transformGradient(double x) {
        ArgChecker.isTrue((x <= this._upper && x >= this._lower ? 1 : 0) != 0, (String)"parameter out of range");
        double t = (x - this._mid) / this._scale;
        return 1.0 / (this._scale * (1.0 - t * t));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this._lower);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this._upper);
        result = prime * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleRangeLimitTransform other = (DoubleRangeLimitTransform)obj;
        if (Double.doubleToLongBits(this._lower) != Double.doubleToLongBits(other._lower)) {
            return false;
        }
        return Double.doubleToLongBits(this._upper) == Double.doubleToLongBits(other._upper);
    }
}

