/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.minimization;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.minimization.MinimumBracketer;
import com.opengamma.strata.math.impl.minimization.ParabolicMinimumBracketer;
import com.opengamma.strata.math.impl.minimization.ScalarMinimizer;
import java.util.function.Function;

public class GoldenSectionMinimizer1D
implements ScalarMinimizer {
    private static final double GOLDEN = 0.61803399;
    private static final MinimumBracketer BRACKETER = new ParabolicMinimumBracketer();
    private static final int MAX_ITER = 10000;
    private static final double EPS = 1.0E-12;

    @Override
    public double minimize(Function<Double, Double> f, double startPosition, double lower, double upper) {
        return this.minimize(f, lower, upper);
    }

    public double minimize(Function<Double, Double> f, double lower, double upper) {
        double x2;
        double x1;
        ArgChecker.notNull(f, (String)"function");
        int i = 0;
        double[] triplet = BRACKETER.getBracketedPoints(f, lower, upper);
        double x0 = triplet[0];
        double x3 = triplet[2];
        if (Math.abs(triplet[2] - triplet[1]) > Math.abs(triplet[1] - triplet[0])) {
            x1 = triplet[1];
            x2 = triplet[2] + 0.61803399 * (triplet[1] - triplet[2]);
        } else {
            x2 = triplet[1];
            x1 = triplet[0] + 0.61803399 * (triplet[1] - triplet[0]);
        }
        double f1 = f.apply(x1);
        double f2 = f.apply(x2);
        while (Math.abs(x3 - x0) > 1.0E-12 * (Math.abs(x1) + Math.abs(x2))) {
            double temp;
            if (f2 < f1) {
                temp = 0.61803399 * (x2 - x3) + x3;
                x0 = x1;
                x1 = x2;
                x2 = temp;
                f1 = f2;
                f2 = f.apply(temp);
            } else {
                temp = 0.61803399 * (x1 - x0) + x0;
                x3 = x2;
                x2 = x1;
                x1 = temp;
                f2 = f1;
                f1 = f.apply(temp);
            }
            if (++i <= 10000) continue;
            throw new MathException("Could not find minimum: this should not happen because minimum should have been successfully bracketed");
        }
        if (f1 < f2) {
            return x1;
        }
        return x2;
    }

    @Override
    public Double minimize(Function<Double, Double> function, Double startPosition) {
        throw new UnsupportedOperationException("Need lower and upper bounds to use this minimization method");
    }
}

