/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.minimization;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebra;
import com.opengamma.strata.math.impl.matrix.OGMatrixAlgebra;
import com.opengamma.strata.math.impl.minimization.NonLinearParameterTransforms;
import java.util.function.Function;

public class NonLinearTransformFunction {
    private static final MatrixAlgebra MA = new OGMatrixAlgebra();
    private final NonLinearParameterTransforms _transform;
    private final Function<DoubleArray, DoubleArray> _func;
    private final Function<DoubleArray, DoubleMatrix> _jac;

    public NonLinearTransformFunction(final Function<DoubleArray, DoubleArray> func, final Function<DoubleArray, DoubleMatrix> jac, NonLinearParameterTransforms transform) {
        this._transform = transform;
        this._func = new Function<DoubleArray, DoubleArray>(){

            @Override
            public DoubleArray apply(DoubleArray yStar) {
                DoubleArray y = NonLinearTransformFunction.this._transform.inverseTransform(yStar);
                return (DoubleArray)func.apply(y);
            }
        };
        this._jac = new Function<DoubleArray, DoubleMatrix>(){

            @Override
            public DoubleMatrix apply(DoubleArray yStar) {
                DoubleArray y = NonLinearTransformFunction.this._transform.inverseTransform(yStar);
                DoubleMatrix h = (DoubleMatrix)jac.apply(y);
                DoubleMatrix invJ = NonLinearTransformFunction.this._transform.inverseJacobian(yStar);
                return (DoubleMatrix)MA.multiply((Matrix)h, (Matrix)invJ);
            }
        };
    }

    public Function<DoubleArray, DoubleArray> getFittingFunction() {
        return this._func;
    }

    public Function<DoubleArray, DoubleMatrix> getFittingJacobian() {
        return this._jac;
    }
}

