/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.minimization;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.minimization.ParameterLimitsTransform;

public class SingleRangeLimitTransform
implements ParameterLimitsTransform {
    private static final double EXP_MAX = 50.0;
    private final double _limit;
    private final int _sign;

    public SingleRangeLimitTransform(double a, ParameterLimitsTransform.LimitType limitType) {
        this._limit = a;
        this._sign = limitType == ParameterLimitsTransform.LimitType.GREATER_THAN ? 1 : -1;
    }

    @Override
    public double inverseTransform(double y) {
        if (y > 50.0) {
            return this._limit + (double)this._sign * y;
        }
        if (y < -50.0) {
            return this._limit;
        }
        return this._limit + (double)this._sign * Math.log(Math.exp(y) + 1.0);
    }

    @Override
    public double transform(double x) {
        ArgChecker.isTrue(((double)this._sign * x >= (double)this._sign * this._limit ? 1 : 0) != 0, (String)"x not in limit");
        if (x == this._limit) {
            return -50.0;
        }
        double r = (double)this._sign * (x - this._limit);
        if (r > 50.0) {
            return r;
        }
        return Math.log(Math.exp(r) - 1.0);
    }

    @Override
    public double inverseTransformGradient(double y) {
        if (y > 50.0) {
            return this._sign;
        }
        double temp = Math.exp(y);
        return (double)this._sign * temp / (temp + 1.0);
    }

    @Override
    public double transformGradient(double x) {
        ArgChecker.isTrue(((double)this._sign * x >= (double)this._sign * this._limit ? 1 : 0) != 0, (String)"x not in limit");
        double r = (double)this._sign * (x - this._limit);
        if (r > 50.0) {
            return 1.0;
        }
        double temp = Math.exp(r);
        return (double)this._sign * temp / (temp - 1.0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this._limit);
        result = prime * result + (int)(temp ^ temp >>> 32);
        result = prime * result + this._sign;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleRangeLimitTransform other = (SingleRangeLimitTransform)obj;
        if (Double.doubleToLongBits(this._limit) != Double.doubleToLongBits(other._limit)) {
            return false;
        }
        return this._sign == other._sign;
    }
}

